/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDashboardPermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDashboardPermissionsResponse.Builder, DescribeDashboardPermissionsResponse> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(DescribeDashboardPermissionsResponse::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardArn").getter(getter(DescribeDashboardPermissionsResponse::dashboardArn))
            .setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(DescribeDashboardPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDashboardPermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDashboardPermissionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<LinkSharingConfiguration> LINK_SHARING_CONFIGURATION_FIELD = SdkField
            .<LinkSharingConfiguration> builder(MarshallingType.SDK_POJO).memberName("LinkSharingConfiguration")
            .getter(getter(DescribeDashboardPermissionsResponse::linkSharingConfiguration))
            .setter(setter(Builder::linkSharingConfiguration)).constructor(LinkSharingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkSharingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD,
            DASHBOARD_ARN_FIELD, PERMISSIONS_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, LINK_SHARING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardId;

    private final String dashboardArn;

    private final List<ResourcePermission> permissions;

    private final Integer status;

    private final String requestId;

    private final LinkSharingConfiguration linkSharingConfiguration;

    private DescribeDashboardPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardId = builder.dashboardId;
        this.dashboardArn = builder.dashboardArn;
        this.permissions = builder.permissions;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.linkSharingConfiguration = builder.linkSharingConfiguration;
    }

    /**
     * <p>
     * The ID for the dashboard.
     * </p>
     * 
     * @return The ID for the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dashboard.
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains the permissions for the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A structure that contains the permissions for the dashboard.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * A structure that contains the configuration of a shareable link that grants access to the dashboard. Your users
     * can use the link to view and interact with the dashboard, if the dashboard has been shared with them. For more
     * information about sharing dashboards, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.
     * </p>
     * 
     * @return A structure that contains the configuration of a shareable link that grants access to the dashboard. Your
     *         users can use the link to view and interact with the dashboard, if the dashboard has been shared with
     *         them. For more information about sharing dashboards, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing
     *         Dashboards</a>.
     */
    public final LinkSharingConfiguration linkSharingConfiguration() {
        return linkSharingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(linkSharingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDashboardPermissionsResponse)) {
            return false;
        }
        DescribeDashboardPermissionsResponse other = (DescribeDashboardPermissionsResponse) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(dashboardArn(), other.dashboardArn())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(status(), other.status()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(linkSharingConfiguration(), other.linkSharingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDashboardPermissionsResponse").add("DashboardId", dashboardId())
                .add("DashboardArn", dashboardArn()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("Status", status()).add("RequestId", requestId())
                .add("LinkSharingConfiguration", linkSharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "LinkSharingConfiguration":
            return Optional.ofNullable(clazz.cast(linkSharingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardId", DASHBOARD_ID_FIELD);
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("LinkSharingConfiguration", LINK_SHARING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDashboardPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeDashboardPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDashboardPermissionsResponse> {
        /**
         * <p>
         * The ID for the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The Amazon Resource Name (ARN) of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * A structure that contains the permissions for the dashboard.
         * </p>
         * 
         * @param permissions
         *        A structure that contains the permissions for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A structure that contains the permissions for the dashboard.
         * </p>
         * 
         * @param permissions
         *        A structure that contains the permissions for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A structure that contains the permissions for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder#build()} is called
         * immediately and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ResourcePermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * A structure that contains the configuration of a shareable link that grants access to the dashboard. Your
         * users can use the link to view and interact with the dashboard, if the dashboard has been shared with them.
         * For more information about sharing dashboards, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.
         * </p>
         * 
         * @param linkSharingConfiguration
         *        A structure that contains the configuration of a shareable link that grants access to the dashboard.
         *        Your users can use the link to view and interact with the dashboard, if the dashboard has been shared
         *        with them. For more information about sharing dashboards, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing
         *        Dashboards</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkSharingConfiguration(LinkSharingConfiguration linkSharingConfiguration);

        /**
         * <p>
         * A structure that contains the configuration of a shareable link that grants access to the dashboard. Your
         * users can use the link to view and interact with the dashboard, if the dashboard has been shared with them.
         * For more information about sharing dashboards, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/sharing-a-dashboard.html">Sharing Dashboards</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LinkSharingConfiguration.Builder}
         * avoiding the need to create one manually via {@link LinkSharingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LinkSharingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #linkSharingConfiguration(LinkSharingConfiguration)}.
         * 
         * @param linkSharingConfiguration
         *        a consumer that will call methods on {@link LinkSharingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #linkSharingConfiguration(LinkSharingConfiguration)
         */
        default Builder linkSharingConfiguration(Consumer<LinkSharingConfiguration.Builder> linkSharingConfiguration) {
            return linkSharingConfiguration(LinkSharingConfiguration.builder().applyMutation(linkSharingConfiguration).build());
        }
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String dashboardId;

        private String dashboardArn;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private Integer status;

        private String requestId;

        private LinkSharingConfiguration linkSharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDashboardPermissionsResponse model) {
            super(model);
            dashboardId(model.dashboardId);
            dashboardArn(model.dashboardArn);
            permissions(model.permissions);
            status(model.status);
            requestId(model.requestId);
            linkSharingConfiguration(model.linkSharingConfiguration);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = UpdateResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = UpdateResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final LinkSharingConfiguration.Builder getLinkSharingConfiguration() {
            return linkSharingConfiguration != null ? linkSharingConfiguration.toBuilder() : null;
        }

        public final void setLinkSharingConfiguration(LinkSharingConfiguration.BuilderImpl linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration != null ? linkSharingConfiguration.build() : null;
        }

        @Override
        public final Builder linkSharingConfiguration(LinkSharingConfiguration linkSharingConfiguration) {
            this.linkSharingConfiguration = linkSharingConfiguration;
            return this;
        }

        @Override
        public DescribeDashboardPermissionsResponse build() {
            return new DescribeDashboardPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
