/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of overrides for a specific <code>RefreshsSchedule</code> resource that is present in the asset bundle that is
 * imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobRefreshScheduleOverrideParameters
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AssetBundleImportJobRefreshScheduleOverrideParameters.Builder, AssetBundleImportJobRefreshScheduleOverrideParameters> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(AssetBundleImportJobRefreshScheduleOverrideParameters::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> SCHEDULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleId").getter(getter(AssetBundleImportJobRefreshScheduleOverrideParameters::scheduleId))
            .setter(setter(Builder::scheduleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleId").build()).build();

    private static final SdkField<Instant> START_AFTER_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartAfterDateTime")
            .getter(getter(AssetBundleImportJobRefreshScheduleOverrideParameters::startAfterDateTime))
            .setter(setter(Builder::startAfterDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAfterDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            SCHEDULE_ID_FIELD, START_AFTER_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final String scheduleId;

    private final Instant startAfterDateTime;

    private AssetBundleImportJobRefreshScheduleOverrideParameters(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.scheduleId = builder.scheduleId;
        this.startAfterDateTime = builder.startAfterDateTime;
    }

    /**
     * <p>
     * A partial identifier for the specific <code>RefreshSchedule</code> resource that is being overridden. This
     * structure is used together with the <code>ScheduleID</code> structure.
     * </p>
     * 
     * @return A partial identifier for the specific <code>RefreshSchedule</code> resource that is being overridden.
     *         This structure is used together with the <code>ScheduleID</code> structure.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * A partial identifier for the specific <code>RefreshSchedule</code> resource being overridden. This structure is
     * used together with the <code>DataSetId</code> structure.
     * </p>
     * 
     * @return A partial identifier for the specific <code>RefreshSchedule</code> resource being overridden. This
     *         structure is used together with the <code>DataSetId</code> structure.
     */
    public final String scheduleId() {
        return scheduleId;
    }

    /**
     * <p>
     * An override for the <code>StartAfterDateTime</code> of a <code>RefreshSchedule</code>. Make sure that the
     * <code>StartAfterDateTime</code> is set to a time that takes place in the future.
     * </p>
     * 
     * @return An override for the <code>StartAfterDateTime</code> of a <code>RefreshSchedule</code>. Make sure that the
     *         <code>StartAfterDateTime</code> is set to a time that takes place in the future.
     */
    public final Instant startAfterDateTime() {
        return startAfterDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleId());
        hashCode = 31 * hashCode + Objects.hashCode(startAfterDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobRefreshScheduleOverrideParameters)) {
            return false;
        }
        AssetBundleImportJobRefreshScheduleOverrideParameters other = (AssetBundleImportJobRefreshScheduleOverrideParameters) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(scheduleId(), other.scheduleId())
                && Objects.equals(startAfterDateTime(), other.startAfterDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobRefreshScheduleOverrideParameters").add("DataSetId", dataSetId())
                .add("ScheduleId", scheduleId()).add("StartAfterDateTime", startAfterDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "ScheduleId":
            return Optional.ofNullable(clazz.cast(scheduleId()));
        case "StartAfterDateTime":
            return Optional.ofNullable(clazz.cast(startAfterDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("ScheduleId", SCHEDULE_ID_FIELD);
        map.put("StartAfterDateTime", START_AFTER_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobRefreshScheduleOverrideParameters, T> g) {
        return obj -> g.apply((AssetBundleImportJobRefreshScheduleOverrideParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobRefreshScheduleOverrideParameters> {
        /**
         * <p>
         * A partial identifier for the specific <code>RefreshSchedule</code> resource that is being overridden. This
         * structure is used together with the <code>ScheduleID</code> structure.
         * </p>
         * 
         * @param dataSetId
         *        A partial identifier for the specific <code>RefreshSchedule</code> resource that is being overridden.
         *        This structure is used together with the <code>ScheduleID</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * A partial identifier for the specific <code>RefreshSchedule</code> resource being overridden. This structure
         * is used together with the <code>DataSetId</code> structure.
         * </p>
         * 
         * @param scheduleId
         *        A partial identifier for the specific <code>RefreshSchedule</code> resource being overridden. This
         *        structure is used together with the <code>DataSetId</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleId(String scheduleId);

        /**
         * <p>
         * An override for the <code>StartAfterDateTime</code> of a <code>RefreshSchedule</code>. Make sure that the
         * <code>StartAfterDateTime</code> is set to a time that takes place in the future.
         * </p>
         * 
         * @param startAfterDateTime
         *        An override for the <code>StartAfterDateTime</code> of a <code>RefreshSchedule</code>. Make sure that
         *        the <code>StartAfterDateTime</code> is set to a time that takes place in the future.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAfterDateTime(Instant startAfterDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private String scheduleId;

        private Instant startAfterDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobRefreshScheduleOverrideParameters model) {
            dataSetId(model.dataSetId);
            scheduleId(model.scheduleId);
            startAfterDateTime(model.startAfterDateTime);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getScheduleId() {
            return scheduleId;
        }

        public final void setScheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
        }

        @Override
        public final Builder scheduleId(String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public final Instant getStartAfterDateTime() {
            return startAfterDateTime;
        }

        public final void setStartAfterDateTime(Instant startAfterDateTime) {
            this.startAfterDateTime = startAfterDateTime;
        }

        @Override
        public final Builder startAfterDateTime(Instant startAfterDateTime) {
            this.startAfterDateTime = startAfterDateTime;
            return this;
        }

        @Override
        public AssetBundleImportJobRefreshScheduleOverrideParameters build() {
            return new AssetBundleImportJobRefreshScheduleOverrideParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
