/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the override permission configurations that modify the permissions for specified resources
 * before the resource is imported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetBundleImportJobOverridePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetBundleImportJobOverridePermissions.Builder, AssetBundleImportJobOverridePermissions> {
    private static final SdkField<List<AssetBundleImportJobDataSourceOverridePermissions>> DATA_SOURCES_FIELD = SdkField
            .<List<AssetBundleImportJobDataSourceOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("DataSources")
            .getter(getter(AssetBundleImportJobOverridePermissions::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSourceOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSourceOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDataSetOverridePermissions>> DATA_SETS_FIELD = SdkField
            .<List<AssetBundleImportJobDataSetOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("DataSets")
            .getter(getter(AssetBundleImportJobOverridePermissions::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDataSetOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDataSetOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobThemeOverridePermissions>> THEMES_FIELD = SdkField
            .<List<AssetBundleImportJobThemeOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("Themes")
            .getter(getter(AssetBundleImportJobOverridePermissions::themes))
            .setter(setter(Builder::themes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Themes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobThemeOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobThemeOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobAnalysisOverridePermissions>> ANALYSES_FIELD = SdkField
            .<List<AssetBundleImportJobAnalysisOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("Analyses")
            .getter(getter(AssetBundleImportJobOverridePermissions::analyses))
            .setter(setter(Builder::analyses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analyses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobAnalysisOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobAnalysisOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobDashboardOverridePermissions>> DASHBOARDS_FIELD = SdkField
            .<List<AssetBundleImportJobDashboardOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("Dashboards")
            .getter(getter(AssetBundleImportJobOverridePermissions::dashboards))
            .setter(setter(Builder::dashboards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobDashboardOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobDashboardOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetBundleImportJobFolderOverridePermissions>> FOLDERS_FIELD = SdkField
            .<List<AssetBundleImportJobFolderOverridePermissions>> builder(MarshallingType.LIST)
            .memberName("Folders")
            .getter(getter(AssetBundleImportJobOverridePermissions::folders))
            .setter(setter(Builder::folders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetBundleImportJobFolderOverridePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetBundleImportJobFolderOverridePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCES_FIELD,
            DATA_SETS_FIELD, THEMES_FIELD, ANALYSES_FIELD, DASHBOARDS_FIELD, FOLDERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AssetBundleImportJobDataSourceOverridePermissions> dataSources;

    private final List<AssetBundleImportJobDataSetOverridePermissions> dataSets;

    private final List<AssetBundleImportJobThemeOverridePermissions> themes;

    private final List<AssetBundleImportJobAnalysisOverridePermissions> analyses;

    private final List<AssetBundleImportJobDashboardOverridePermissions> dashboards;

    private final List<AssetBundleImportJobFolderOverridePermissions> folders;

    private AssetBundleImportJobOverridePermissions(BuilderImpl builder) {
        this.dataSources = builder.dataSources;
        this.dataSets = builder.dataSets;
        this.themes = builder.themes;
        this.analyses = builder.analyses;
        this.dashboards = builder.dashboards;
        this.folders = builder.folders;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset bundle
     * that is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset
     *         bundle that is imported.
     */
    public final List<AssetBundleImportJobDataSourceOverridePermissions> dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset bundle that
     * is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset
     *         bundle that is imported.
     */
    public final List<AssetBundleImportJobDataSetOverridePermissions> dataSets() {
        return dataSets;
    }

    /**
     * For responses, this returns true if the service returned a value for the Themes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThemes() {
        return themes != null && !(themes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle that is
     * imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThemes} method.
     * </p>
     * 
     * @return A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle
     *         that is imported.
     */
    public final List<AssetBundleImportJobThemeOverridePermissions> themes() {
        return themes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Analyses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnalyses() {
        return analyses != null && !(analyses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset bundle that
     * is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalyses} method.
     * </p>
     * 
     * @return A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset
     *         bundle that is imported.
     */
    public final List<AssetBundleImportJobAnalysisOverridePermissions> analyses() {
        return analyses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dashboards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDashboards() {
        return dashboards != null && !(dashboards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset bundle
     * that is imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDashboards} method.
     * </p>
     * 
     * @return A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset
     *         bundle that is imported.
     */
    public final List<AssetBundleImportJobDashboardOverridePermissions> dashboards() {
        return dashboards;
    }

    /**
     * For responses, this returns true if the service returned a value for the Folders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolders() {
        return folders != null && !(folders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of permissions for the folders that you want to apply overrides to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolders} method.
     * </p>
     * 
     * @return A list of permissions for the folders that you want to apply overrides to.
     */
    public final List<AssetBundleImportJobFolderOverridePermissions> folders() {
        return folders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThemes() ? themes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalyses() ? analyses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDashboards() ? dashboards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFolders() ? folders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobOverridePermissions other = (AssetBundleImportJobOverridePermissions) obj;
        return hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && hasThemes() == other.hasThemes() && Objects.equals(themes(), other.themes())
                && hasAnalyses() == other.hasAnalyses() && Objects.equals(analyses(), other.analyses())
                && hasDashboards() == other.hasDashboards() && Objects.equals(dashboards(), other.dashboards())
                && hasFolders() == other.hasFolders() && Objects.equals(folders(), other.folders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetBundleImportJobOverridePermissions")
                .add("DataSources", hasDataSources() ? dataSources() : null).add("DataSets", hasDataSets() ? dataSets() : null)
                .add("Themes", hasThemes() ? themes() : null).add("Analyses", hasAnalyses() ? analyses() : null)
                .add("Dashboards", hasDashboards() ? dashboards() : null).add("Folders", hasFolders() ? folders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "DataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "Themes":
            return Optional.ofNullable(clazz.cast(themes()));
        case "Analyses":
            return Optional.ofNullable(clazz.cast(analyses()));
        case "Dashboards":
            return Optional.ofNullable(clazz.cast(dashboards()));
        case "Folders":
            return Optional.ofNullable(clazz.cast(folders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSources", DATA_SOURCES_FIELD);
        map.put("DataSets", DATA_SETS_FIELD);
        map.put("Themes", THEMES_FIELD);
        map.put("Analyses", ANALYSES_FIELD);
        map.put("Dashboards", DASHBOARDS_FIELD);
        map.put("Folders", FOLDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobOverridePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetBundleImportJobOverridePermissions> {
        /**
         * <p>
         * A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset
         * bundle that is imported.
         * </p>
         * 
         * @param dataSources
         *        A list of permissions overrides for any <code>DataSource</code> resources that are present in the
         *        asset bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<AssetBundleImportJobDataSourceOverridePermissions> dataSources);

        /**
         * <p>
         * A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset
         * bundle that is imported.
         * </p>
         * 
         * @param dataSources
         *        A list of permissions overrides for any <code>DataSource</code> resources that are present in the
         *        asset bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(AssetBundleImportJobDataSourceOverridePermissions... dataSources);

        /**
         * <p>
         * A list of permissions overrides for any <code>DataSource</code> resources that are present in the asset
         * bundle that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSources(List<AssetBundleImportJobDataSourceOverridePermissions>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSourceOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<AssetBundleImportJobDataSourceOverridePermissions>)
         */
        Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverridePermissions.Builder>... dataSources);

        /**
         * <p>
         * A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param dataSets
         *        A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<AssetBundleImportJobDataSetOverridePermissions> dataSets);

        /**
         * <p>
         * A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param dataSets
         *        A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(AssetBundleImportJobDataSetOverridePermissions... dataSets);

        /**
         * <p>
         * A list of permissions overrides for any <code>DataSet</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dataSets(List<AssetBundleImportJobDataSetOverridePermissions>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDataSetOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<AssetBundleImportJobDataSetOverridePermissions>)
         */
        Builder dataSets(Consumer<AssetBundleImportJobDataSetOverridePermissions.Builder>... dataSets);

        /**
         * <p>
         * A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param themes
         *        A list of permissions overrides for any <code>Theme</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(Collection<AssetBundleImportJobThemeOverridePermissions> themes);

        /**
         * <p>
         * A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param themes
         *        A list of permissions overrides for any <code>Theme</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themes(AssetBundleImportJobThemeOverridePermissions... themes);

        /**
         * <p>
         * A list of permissions overrides for any <code>Theme</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #themes(List<AssetBundleImportJobThemeOverridePermissions>)}.
         * 
         * @param themes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobThemeOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themes(java.util.Collection<AssetBundleImportJobThemeOverridePermissions>)
         */
        Builder themes(Consumer<AssetBundleImportJobThemeOverridePermissions.Builder>... themes);

        /**
         * <p>
         * A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param analyses
         *        A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(Collection<AssetBundleImportJobAnalysisOverridePermissions> analyses);

        /**
         * <p>
         * A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param analyses
         *        A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyses(AssetBundleImportJobAnalysisOverridePermissions... analyses);

        /**
         * <p>
         * A list of permissions overrides for any <code>Analysis</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #analyses(List<AssetBundleImportJobAnalysisOverridePermissions>)}.
         * 
         * @param analyses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobAnalysisOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analyses(java.util.Collection<AssetBundleImportJobAnalysisOverridePermissions>)
         */
        Builder analyses(Consumer<AssetBundleImportJobAnalysisOverridePermissions.Builder>... analyses);

        /**
         * <p>
         * A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param dashboards
         *        A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(Collection<AssetBundleImportJobDashboardOverridePermissions> dashboards);

        /**
         * <p>
         * A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * 
         * @param dashboards
         *        A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset
         *        bundle that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboards(AssetBundleImportJobDashboardOverridePermissions... dashboards);

        /**
         * <p>
         * A list of permissions overrides for any <code>Dashboard</code> resources that are present in the asset bundle
         * that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #dashboards(List<AssetBundleImportJobDashboardOverridePermissions>)}.
         * 
         * @param dashboards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobDashboardOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboards(java.util.Collection<AssetBundleImportJobDashboardOverridePermissions>)
         */
        Builder dashboards(Consumer<AssetBundleImportJobDashboardOverridePermissions.Builder>... dashboards);

        /**
         * <p>
         * A list of permissions for the folders that you want to apply overrides to.
         * </p>
         * 
         * @param folders
         *        A list of permissions for the folders that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(Collection<AssetBundleImportJobFolderOverridePermissions> folders);

        /**
         * <p>
         * A list of permissions for the folders that you want to apply overrides to.
         * </p>
         * 
         * @param folders
         *        A list of permissions for the folders that you want to apply overrides to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(AssetBundleImportJobFolderOverridePermissions... folders);

        /**
         * <p>
         * A list of permissions for the folders that you want to apply overrides to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverridePermissions.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverridePermissions#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverridePermissions.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #folders(List<AssetBundleImportJobFolderOverridePermissions>)}.
         * 
         * @param folders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.AssetBundleImportJobFolderOverridePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folders(java.util.Collection<AssetBundleImportJobFolderOverridePermissions>)
         */
        Builder folders(Consumer<AssetBundleImportJobFolderOverridePermissions.Builder>... folders);
    }

    static final class BuilderImpl implements Builder {
        private List<AssetBundleImportJobDataSourceOverridePermissions> dataSources = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDataSetOverridePermissions> dataSets = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobThemeOverridePermissions> themes = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobAnalysisOverridePermissions> analyses = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobDashboardOverridePermissions> dashboards = DefaultSdkAutoConstructList.getInstance();

        private List<AssetBundleImportJobFolderOverridePermissions> folders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobOverridePermissions model) {
            dataSources(model.dataSources);
            dataSets(model.dataSets);
            themes(model.themes);
            analyses(model.analyses);
            dashboards(model.dashboards);
            folders(model.folders);
        }

        public final List<AssetBundleImportJobDataSourceOverridePermissions.Builder> getDataSources() {
            List<AssetBundleImportJobDataSourceOverridePermissions.Builder> result = AssetBundleImportJobDataSourceOverridePermissionsListCopier
                    .copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<AssetBundleImportJobDataSourceOverridePermissions.BuilderImpl> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverridePermissionsListCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<AssetBundleImportJobDataSourceOverridePermissions> dataSources) {
            this.dataSources = AssetBundleImportJobDataSourceOverridePermissionsListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(AssetBundleImportJobDataSourceOverridePermissions... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<AssetBundleImportJobDataSourceOverridePermissions.Builder>... dataSources) {
            dataSources(Stream.of(dataSources)
                    .map(c -> AssetBundleImportJobDataSourceOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDataSetOverridePermissions.Builder> getDataSets() {
            List<AssetBundleImportJobDataSetOverridePermissions.Builder> result = AssetBundleImportJobDataSetOverridePermissionsListCopier
                    .copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<AssetBundleImportJobDataSetOverridePermissions.BuilderImpl> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverridePermissionsListCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<AssetBundleImportJobDataSetOverridePermissions> dataSets) {
            this.dataSets = AssetBundleImportJobDataSetOverridePermissionsListCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(AssetBundleImportJobDataSetOverridePermissions... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<AssetBundleImportJobDataSetOverridePermissions.Builder>... dataSets) {
            dataSets(Stream.of(dataSets)
                    .map(c -> AssetBundleImportJobDataSetOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobThemeOverridePermissions.Builder> getThemes() {
            List<AssetBundleImportJobThemeOverridePermissions.Builder> result = AssetBundleImportJobThemeOverridePermissionsListCopier
                    .copyToBuilder(this.themes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThemes(Collection<AssetBundleImportJobThemeOverridePermissions.BuilderImpl> themes) {
            this.themes = AssetBundleImportJobThemeOverridePermissionsListCopier.copyFromBuilder(themes);
        }

        @Override
        public final Builder themes(Collection<AssetBundleImportJobThemeOverridePermissions> themes) {
            this.themes = AssetBundleImportJobThemeOverridePermissionsListCopier.copy(themes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(AssetBundleImportJobThemeOverridePermissions... themes) {
            themes(Arrays.asList(themes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themes(Consumer<AssetBundleImportJobThemeOverridePermissions.Builder>... themes) {
            themes(Stream.of(themes).map(c -> AssetBundleImportJobThemeOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobAnalysisOverridePermissions.Builder> getAnalyses() {
            List<AssetBundleImportJobAnalysisOverridePermissions.Builder> result = AssetBundleImportJobAnalysisOverridePermissionsListCopier
                    .copyToBuilder(this.analyses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalyses(Collection<AssetBundleImportJobAnalysisOverridePermissions.BuilderImpl> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverridePermissionsListCopier.copyFromBuilder(analyses);
        }

        @Override
        public final Builder analyses(Collection<AssetBundleImportJobAnalysisOverridePermissions> analyses) {
            this.analyses = AssetBundleImportJobAnalysisOverridePermissionsListCopier.copy(analyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(AssetBundleImportJobAnalysisOverridePermissions... analyses) {
            analyses(Arrays.asList(analyses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyses(Consumer<AssetBundleImportJobAnalysisOverridePermissions.Builder>... analyses) {
            analyses(Stream.of(analyses)
                    .map(c -> AssetBundleImportJobAnalysisOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobDashboardOverridePermissions.Builder> getDashboards() {
            List<AssetBundleImportJobDashboardOverridePermissions.Builder> result = AssetBundleImportJobDashboardOverridePermissionsListCopier
                    .copyToBuilder(this.dashboards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashboards(Collection<AssetBundleImportJobDashboardOverridePermissions.BuilderImpl> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverridePermissionsListCopier.copyFromBuilder(dashboards);
        }

        @Override
        public final Builder dashboards(Collection<AssetBundleImportJobDashboardOverridePermissions> dashboards) {
            this.dashboards = AssetBundleImportJobDashboardOverridePermissionsListCopier.copy(dashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(AssetBundleImportJobDashboardOverridePermissions... dashboards) {
            dashboards(Arrays.asList(dashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboards(Consumer<AssetBundleImportJobDashboardOverridePermissions.Builder>... dashboards) {
            dashboards(Stream.of(dashboards)
                    .map(c -> AssetBundleImportJobDashboardOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetBundleImportJobFolderOverridePermissions.Builder> getFolders() {
            List<AssetBundleImportJobFolderOverridePermissions.Builder> result = AssetBundleImportJobFolderOverridePermissionsListCopier
                    .copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolders(Collection<AssetBundleImportJobFolderOverridePermissions.BuilderImpl> folders) {
            this.folders = AssetBundleImportJobFolderOverridePermissionsListCopier.copyFromBuilder(folders);
        }

        @Override
        public final Builder folders(Collection<AssetBundleImportJobFolderOverridePermissions> folders) {
            this.folders = AssetBundleImportJobFolderOverridePermissionsListCopier.copy(folders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(AssetBundleImportJobFolderOverridePermissions... folders) {
            folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folders(Consumer<AssetBundleImportJobFolderOverridePermissions.Builder>... folders) {
            folders(Stream.of(folders).map(c -> AssetBundleImportJobFolderOverridePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetBundleImportJobOverridePermissions build() {
            return new AssetBundleImportJobOverridePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
