/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TemplateAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TemplateAlias> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasName").getter(TemplateAlias.getter(TemplateAlias::aliasName)).setter(TemplateAlias.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TemplateAlias.getter(TemplateAlias::arn)).setter(TemplateAlias.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Long> TEMPLATE_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TemplateVersionNumber").getter(TemplateAlias.getter(TemplateAlias::templateVersionNumber)).setter(TemplateAlias.setter(Builder::templateVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ARN_FIELD, TEMPLATE_VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TemplateAlias.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String aliasName;
    private final String arn;
    private final Long templateVersionNumber;

    private TemplateAlias(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.arn = builder.arn;
        this.templateVersionNumber = builder.templateVersionNumber;
    }

    public final String aliasName() {
        return this.aliasName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Long templateVersionNumber() {
        return this.templateVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateVersionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateAlias)) {
            return false;
        }
        TemplateAlias other = (TemplateAlias)obj;
        return Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.templateVersionNumber(), other.templateVersionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"TemplateAlias").add("AliasName", (Object)this.aliasName()).add("Arn", (Object)this.arn()).add("TemplateVersionNumber", (Object)this.templateVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "TemplateVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.templateVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AliasName", ALIAS_NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("TemplateVersionNumber", TEMPLATE_VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateAlias, T> g) {
        return obj -> g.apply((TemplateAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String arn;
        private Long templateVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateAlias model) {
            this.aliasName(model.aliasName);
            this.arn(model.arn);
            this.templateVersionNumber(model.templateVersionNumber);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getTemplateVersionNumber() {
            return this.templateVersionNumber;
        }

        public final void setTemplateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
        }

        @Override
        public final Builder templateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
            return this;
        }

        public TemplateAlias build() {
            return new TemplateAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TemplateAlias> {
        public Builder aliasName(String var1);

        public Builder arn(String var1);

        public Builder templateVersionNumber(Long var1);
    }
}

