/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PanelBorderStyle;
import software.amazon.awssdk.services.quicksight.model.PanelTitleOptions;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PanelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PanelConfiguration> {
    private static final SdkField<PanelTitleOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(PanelConfiguration.getter(PanelConfiguration::title)).setter(PanelConfiguration.setter(Builder::title)).constructor(PanelTitleOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> BORDER_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderVisibility").getter(PanelConfiguration.getter(PanelConfiguration::borderVisibilityAsString)).setter(PanelConfiguration.setter(Builder::borderVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderVisibility").build()}).build();
    private static final SdkField<String> BORDER_THICKNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderThickness").getter(PanelConfiguration.getter(PanelConfiguration::borderThickness)).setter(PanelConfiguration.setter(Builder::borderThickness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderThickness").build()}).build();
    private static final SdkField<String> BORDER_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderStyle").getter(PanelConfiguration.getter(PanelConfiguration::borderStyleAsString)).setter(PanelConfiguration.setter(Builder::borderStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderStyle").build()}).build();
    private static final SdkField<String> BORDER_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BorderColor").getter(PanelConfiguration.getter(PanelConfiguration::borderColor)).setter(PanelConfiguration.setter(Builder::borderColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorderColor").build()}).build();
    private static final SdkField<String> GUTTER_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GutterVisibility").getter(PanelConfiguration.getter(PanelConfiguration::gutterVisibilityAsString)).setter(PanelConfiguration.setter(Builder::gutterVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GutterVisibility").build()}).build();
    private static final SdkField<String> GUTTER_SPACING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GutterSpacing").getter(PanelConfiguration.getter(PanelConfiguration::gutterSpacing)).setter(PanelConfiguration.setter(Builder::gutterSpacing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GutterSpacing").build()}).build();
    private static final SdkField<String> BACKGROUND_VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundVisibility").getter(PanelConfiguration.getter(PanelConfiguration::backgroundVisibilityAsString)).setter(PanelConfiguration.setter(Builder::backgroundVisibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundVisibility").build()}).build();
    private static final SdkField<String> BACKGROUND_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackgroundColor").getter(PanelConfiguration.getter(PanelConfiguration::backgroundColor)).setter(PanelConfiguration.setter(Builder::backgroundColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackgroundColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, BORDER_VISIBILITY_FIELD, BORDER_THICKNESS_FIELD, BORDER_STYLE_FIELD, BORDER_COLOR_FIELD, GUTTER_VISIBILITY_FIELD, GUTTER_SPACING_FIELD, BACKGROUND_VISIBILITY_FIELD, BACKGROUND_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PanelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PanelTitleOptions title;
    private final String borderVisibility;
    private final String borderThickness;
    private final String borderStyle;
    private final String borderColor;
    private final String gutterVisibility;
    private final String gutterSpacing;
    private final String backgroundVisibility;
    private final String backgroundColor;

    private PanelConfiguration(BuilderImpl builder) {
        this.title = builder.title;
        this.borderVisibility = builder.borderVisibility;
        this.borderThickness = builder.borderThickness;
        this.borderStyle = builder.borderStyle;
        this.borderColor = builder.borderColor;
        this.gutterVisibility = builder.gutterVisibility;
        this.gutterSpacing = builder.gutterSpacing;
        this.backgroundVisibility = builder.backgroundVisibility;
        this.backgroundColor = builder.backgroundColor;
    }

    public final PanelTitleOptions title() {
        return this.title;
    }

    public final Visibility borderVisibility() {
        return Visibility.fromValue(this.borderVisibility);
    }

    public final String borderVisibilityAsString() {
        return this.borderVisibility;
    }

    public final String borderThickness() {
        return this.borderThickness;
    }

    public final PanelBorderStyle borderStyle() {
        return PanelBorderStyle.fromValue(this.borderStyle);
    }

    public final String borderStyleAsString() {
        return this.borderStyle;
    }

    public final String borderColor() {
        return this.borderColor;
    }

    public final Visibility gutterVisibility() {
        return Visibility.fromValue(this.gutterVisibility);
    }

    public final String gutterVisibilityAsString() {
        return this.gutterVisibility;
    }

    public final String gutterSpacing() {
        return this.gutterSpacing;
    }

    public final Visibility backgroundVisibility() {
        return Visibility.fromValue(this.backgroundVisibility);
    }

    public final String backgroundVisibilityAsString() {
        return this.backgroundVisibility;
    }

    public final String backgroundColor() {
        return this.backgroundColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderThickness());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.borderColor());
        hashCode = 31 * hashCode + Objects.hashCode(this.gutterVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gutterSpacing());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backgroundColor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PanelConfiguration)) {
            return false;
        }
        PanelConfiguration other = (PanelConfiguration)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.borderVisibilityAsString(), other.borderVisibilityAsString()) && Objects.equals(this.borderThickness(), other.borderThickness()) && Objects.equals(this.borderStyleAsString(), other.borderStyleAsString()) && Objects.equals(this.borderColor(), other.borderColor()) && Objects.equals(this.gutterVisibilityAsString(), other.gutterVisibilityAsString()) && Objects.equals(this.gutterSpacing(), other.gutterSpacing()) && Objects.equals(this.backgroundVisibilityAsString(), other.backgroundVisibilityAsString()) && Objects.equals(this.backgroundColor(), other.backgroundColor());
    }

    public final String toString() {
        return ToString.builder((String)"PanelConfiguration").add("Title", (Object)this.title()).add("BorderVisibility", (Object)this.borderVisibilityAsString()).add("BorderThickness", (Object)this.borderThickness()).add("BorderStyle", (Object)this.borderStyleAsString()).add("BorderColor", (Object)this.borderColor()).add("GutterVisibility", (Object)this.gutterVisibilityAsString()).add("GutterSpacing", (Object)this.gutterSpacing()).add("BackgroundVisibility", (Object)this.backgroundVisibilityAsString()).add("BackgroundColor", (Object)this.backgroundColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "BorderVisibility": {
                return Optional.ofNullable(clazz.cast(this.borderVisibilityAsString()));
            }
            case "BorderThickness": {
                return Optional.ofNullable(clazz.cast(this.borderThickness()));
            }
            case "BorderStyle": {
                return Optional.ofNullable(clazz.cast(this.borderStyleAsString()));
            }
            case "BorderColor": {
                return Optional.ofNullable(clazz.cast(this.borderColor()));
            }
            case "GutterVisibility": {
                return Optional.ofNullable(clazz.cast(this.gutterVisibilityAsString()));
            }
            case "GutterSpacing": {
                return Optional.ofNullable(clazz.cast(this.gutterSpacing()));
            }
            case "BackgroundVisibility": {
                return Optional.ofNullable(clazz.cast(this.backgroundVisibilityAsString()));
            }
            case "BackgroundColor": {
                return Optional.ofNullable(clazz.cast(this.backgroundColor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Title", TITLE_FIELD);
        map.put("BorderVisibility", BORDER_VISIBILITY_FIELD);
        map.put("BorderThickness", BORDER_THICKNESS_FIELD);
        map.put("BorderStyle", BORDER_STYLE_FIELD);
        map.put("BorderColor", BORDER_COLOR_FIELD);
        map.put("GutterVisibility", GUTTER_VISIBILITY_FIELD);
        map.put("GutterSpacing", GUTTER_SPACING_FIELD);
        map.put("BackgroundVisibility", BACKGROUND_VISIBILITY_FIELD);
        map.put("BackgroundColor", BACKGROUND_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PanelConfiguration, T> g) {
        return obj -> g.apply((PanelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PanelTitleOptions title;
        private String borderVisibility;
        private String borderThickness;
        private String borderStyle;
        private String borderColor;
        private String gutterVisibility;
        private String gutterSpacing;
        private String backgroundVisibility;
        private String backgroundColor;

        private BuilderImpl() {
        }

        private BuilderImpl(PanelConfiguration model) {
            this.title(model.title);
            this.borderVisibility(model.borderVisibility);
            this.borderThickness(model.borderThickness);
            this.borderStyle(model.borderStyle);
            this.borderColor(model.borderColor);
            this.gutterVisibility(model.gutterVisibility);
            this.gutterSpacing(model.gutterSpacing);
            this.backgroundVisibility(model.backgroundVisibility);
            this.backgroundColor(model.backgroundColor);
        }

        public final PanelTitleOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(PanelTitleOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(PanelTitleOptions title) {
            this.title = title;
            return this;
        }

        public final String getBorderVisibility() {
            return this.borderVisibility;
        }

        public final void setBorderVisibility(String borderVisibility) {
            this.borderVisibility = borderVisibility;
        }

        @Override
        public final Builder borderVisibility(String borderVisibility) {
            this.borderVisibility = borderVisibility;
            return this;
        }

        @Override
        public final Builder borderVisibility(Visibility borderVisibility) {
            this.borderVisibility(borderVisibility == null ? null : borderVisibility.toString());
            return this;
        }

        public final String getBorderThickness() {
            return this.borderThickness;
        }

        public final void setBorderThickness(String borderThickness) {
            this.borderThickness = borderThickness;
        }

        @Override
        public final Builder borderThickness(String borderThickness) {
            this.borderThickness = borderThickness;
            return this;
        }

        public final String getBorderStyle() {
            return this.borderStyle;
        }

        public final void setBorderStyle(String borderStyle) {
            this.borderStyle = borderStyle;
        }

        @Override
        public final Builder borderStyle(String borderStyle) {
            this.borderStyle = borderStyle;
            return this;
        }

        @Override
        public final Builder borderStyle(PanelBorderStyle borderStyle) {
            this.borderStyle(borderStyle == null ? null : borderStyle.toString());
            return this;
        }

        public final String getBorderColor() {
            return this.borderColor;
        }

        public final void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public final Builder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public final String getGutterVisibility() {
            return this.gutterVisibility;
        }

        public final void setGutterVisibility(String gutterVisibility) {
            this.gutterVisibility = gutterVisibility;
        }

        @Override
        public final Builder gutterVisibility(String gutterVisibility) {
            this.gutterVisibility = gutterVisibility;
            return this;
        }

        @Override
        public final Builder gutterVisibility(Visibility gutterVisibility) {
            this.gutterVisibility(gutterVisibility == null ? null : gutterVisibility.toString());
            return this;
        }

        public final String getGutterSpacing() {
            return this.gutterSpacing;
        }

        public final void setGutterSpacing(String gutterSpacing) {
            this.gutterSpacing = gutterSpacing;
        }

        @Override
        public final Builder gutterSpacing(String gutterSpacing) {
            this.gutterSpacing = gutterSpacing;
            return this;
        }

        public final String getBackgroundVisibility() {
            return this.backgroundVisibility;
        }

        public final void setBackgroundVisibility(String backgroundVisibility) {
            this.backgroundVisibility = backgroundVisibility;
        }

        @Override
        public final Builder backgroundVisibility(String backgroundVisibility) {
            this.backgroundVisibility = backgroundVisibility;
            return this;
        }

        @Override
        public final Builder backgroundVisibility(Visibility backgroundVisibility) {
            this.backgroundVisibility(backgroundVisibility == null ? null : backgroundVisibility.toString());
            return this;
        }

        public final String getBackgroundColor() {
            return this.backgroundColor;
        }

        public final void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        @Override
        public final Builder backgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public PanelConfiguration build() {
            return new PanelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PanelConfiguration> {
        public Builder title(PanelTitleOptions var1);

        default public Builder title(Consumer<PanelTitleOptions.Builder> title) {
            return this.title((PanelTitleOptions)((PanelTitleOptions.Builder)PanelTitleOptions.builder().applyMutation(title)).build());
        }

        public Builder borderVisibility(String var1);

        public Builder borderVisibility(Visibility var1);

        public Builder borderThickness(String var1);

        public Builder borderStyle(String var1);

        public Builder borderStyle(PanelBorderStyle var1);

        public Builder borderColor(String var1);

        public Builder gutterVisibility(String var1);

        public Builder gutterVisibility(Visibility var1);

        public Builder gutterSpacing(String var1);

        public Builder backgroundVisibility(String var1);

        public Builder backgroundVisibility(Visibility var1);

        public Builder backgroundColor(String var1);
    }
}

