/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.KPIFieldWells;
import software.amazon.awssdk.services.quicksight.model.KPIOptions;
import software.amazon.awssdk.services.quicksight.model.KPISortConfiguration;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPIConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPIConfiguration> {
    private static final SdkField<KPIFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(KPIConfiguration.getter(KPIConfiguration::fieldWells)).setter(KPIConfiguration.setter(Builder::fieldWells)).constructor(KPIFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<KPISortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(KPIConfiguration.getter(KPIConfiguration::sortConfiguration)).setter(KPIConfiguration.setter(Builder::sortConfiguration)).constructor(KPISortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<KPIOptions> KPI_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KPIOptions").getter(KPIConfiguration.getter(KPIConfiguration::kpiOptions)).setter(KPIConfiguration.setter(Builder::kpiOptions)).constructor(KPIOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KPIOptions").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(KPIConfiguration.getter(KPIConfiguration::interactions)).setter(KPIConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, KPI_OPTIONS_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KPIConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KPIFieldWells fieldWells;
    private final KPISortConfiguration sortConfiguration;
    private final KPIOptions kpiOptions;
    private final VisualInteractionOptions interactions;

    private KPIConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.kpiOptions = builder.kpiOptions;
        this.interactions = builder.interactions;
    }

    public final KPIFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final KPISortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final KPIOptions kpiOptions() {
        return this.kpiOptions;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kpiOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConfiguration)) {
            return false;
        }
        KPIConfiguration other = (KPIConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.kpiOptions(), other.kpiOptions()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"KPIConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("KPIOptions", (Object)this.kpiOptions()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "KPIOptions": {
                return Optional.ofNullable(clazz.cast(this.kpiOptions()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("KPIOptions", KPI_OPTIONS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIConfiguration, T> g) {
        return obj -> g.apply((KPIConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KPIFieldWells fieldWells;
        private KPISortConfiguration sortConfiguration;
        private KPIOptions kpiOptions;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.kpiOptions(model.kpiOptions);
            this.interactions(model.interactions);
        }

        public final KPIFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(KPIFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(KPIFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final KPISortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(KPISortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(KPISortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final KPIOptions.Builder getKpiOptions() {
            return this.kpiOptions != null ? this.kpiOptions.toBuilder() : null;
        }

        public final void setKpiOptions(KPIOptions.BuilderImpl kpiOptions) {
            this.kpiOptions = kpiOptions != null ? kpiOptions.build() : null;
        }

        @Override
        public final Builder kpiOptions(KPIOptions kpiOptions) {
            this.kpiOptions = kpiOptions;
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public KPIConfiguration build() {
            return new KPIConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPIConfiguration> {
        public Builder fieldWells(KPIFieldWells var1);

        default public Builder fieldWells(Consumer<KPIFieldWells.Builder> fieldWells) {
            return this.fieldWells((KPIFieldWells)((KPIFieldWells.Builder)KPIFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(KPISortConfiguration var1);

        default public Builder sortConfiguration(Consumer<KPISortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((KPISortConfiguration)((KPISortConfiguration.Builder)KPISortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder kpiOptions(KPIOptions var1);

        default public Builder kpiOptions(Consumer<KPIOptions.Builder> kpiOptions) {
            return this.kpiOptions((KPIOptions)((KPIOptions.Builder)KPIOptions.builder().applyMutation(kpiOptions)).build());
        }

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

