/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DashboardsQAStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDashboardsQaConfigurationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDashboardsQaConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateDashboardsQaConfigurationRequest.getter(UpdateDashboardsQaConfigurationRequest::awsAccountId)).setter(UpdateDashboardsQaConfigurationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DASHBOARDS_QA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardsQAStatus").getter(UpdateDashboardsQaConfigurationRequest.getter(UpdateDashboardsQaConfigurationRequest::dashboardsQAStatusAsString)).setter(UpdateDashboardsQaConfigurationRequest.setter(Builder::dashboardsQAStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardsQAStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DASHBOARDS_QA_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDashboardsQaConfigurationRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String dashboardsQAStatus;

    private UpdateDashboardsQaConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardsQAStatus = builder.dashboardsQAStatus;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final DashboardsQAStatus dashboardsQAStatus() {
        return DashboardsQAStatus.fromValue(this.dashboardsQAStatus);
    }

    public final String dashboardsQAStatusAsString() {
        return this.dashboardsQAStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardsQAStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardsQaConfigurationRequest)) {
            return false;
        }
        UpdateDashboardsQaConfigurationRequest other = (UpdateDashboardsQaConfigurationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dashboardsQAStatusAsString(), other.dashboardsQAStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDashboardsQaConfigurationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DashboardsQAStatus", (Object)this.dashboardsQAStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DashboardsQAStatus": {
                return Optional.ofNullable(clazz.cast(this.dashboardsQAStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("DashboardsQAStatus", DASHBOARDS_QA_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardsQaConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDashboardsQaConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dashboardsQAStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardsQaConfigurationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dashboardsQAStatus(model.dashboardsQAStatus);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardsQAStatus() {
            return this.dashboardsQAStatus;
        }

        public final void setDashboardsQAStatus(String dashboardsQAStatus) {
            this.dashboardsQAStatus = dashboardsQAStatus;
        }

        @Override
        public final Builder dashboardsQAStatus(String dashboardsQAStatus) {
            this.dashboardsQAStatus = dashboardsQAStatus;
            return this;
        }

        @Override
        public final Builder dashboardsQAStatus(DashboardsQAStatus dashboardsQAStatus) {
            this.dashboardsQAStatus(dashboardsQAStatus == null ? null : dashboardsQAStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardsQaConfigurationRequest build() {
            return new UpdateDashboardsQaConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDashboardsQaConfigurationRequest> {
        public Builder awsAccountId(String var1);

        public Builder dashboardsQAStatus(String var1);

        public Builder dashboardsQAStatus(DashboardsQAStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

