/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BrandDefinition;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrandRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateBrandRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateBrandRequest.getter(UpdateBrandRequest::awsAccountId)).setter(UpdateBrandRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> BRAND_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrandId").getter(UpdateBrandRequest.getter(UpdateBrandRequest::brandId)).setter(UpdateBrandRequest.setter(Builder::brandId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("BrandId").build()}).build();
    private static final SdkField<BrandDefinition> BRAND_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrandDefinition").getter(UpdateBrandRequest.getter(UpdateBrandRequest::brandDefinition)).setter(UpdateBrandRequest.setter(Builder::brandDefinition)).constructor(BrandDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, BRAND_ID_FIELD, BRAND_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBrandRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String brandId;
    private final BrandDefinition brandDefinition;

    private UpdateBrandRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.brandId = builder.brandId;
        this.brandDefinition = builder.brandDefinition;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String brandId() {
        return this.brandId;
    }

    public final BrandDefinition brandDefinition() {
        return this.brandDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrandRequest)) {
            return false;
        }
        UpdateBrandRequest other = (UpdateBrandRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.brandId(), other.brandId()) && Objects.equals(this.brandDefinition(), other.brandDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrandRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("BrandId", (Object)this.brandId()).add("BrandDefinition", (Object)this.brandDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "BrandId": {
                return Optional.ofNullable(clazz.cast(this.brandId()));
            }
            case "BrandDefinition": {
                return Optional.ofNullable(clazz.cast(this.brandDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("BrandId", BRAND_ID_FIELD);
        map.put("BrandDefinition", BRAND_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrandRequest, T> g) {
        return obj -> g.apply((UpdateBrandRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String brandId;
        private BrandDefinition brandDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrandRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.brandId(model.brandId);
            this.brandDefinition(model.brandDefinition);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getBrandId() {
            return this.brandId;
        }

        public final void setBrandId(String brandId) {
            this.brandId = brandId;
        }

        @Override
        public final Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public final BrandDefinition.Builder getBrandDefinition() {
            return this.brandDefinition != null ? this.brandDefinition.toBuilder() : null;
        }

        public final void setBrandDefinition(BrandDefinition.BuilderImpl brandDefinition) {
            this.brandDefinition = brandDefinition != null ? brandDefinition.build() : null;
        }

        @Override
        public final Builder brandDefinition(BrandDefinition brandDefinition) {
            this.brandDefinition = brandDefinition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrandRequest build() {
            return new UpdateBrandRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrandRequest> {
        public Builder awsAccountId(String var1);

        public Builder brandId(String var1);

        public Builder brandDefinition(BrandDefinition var1);

        default public Builder brandDefinition(Consumer<BrandDefinition.Builder> brandDefinition) {
            return this.brandDefinition((BrandDefinition)((BrandDefinition.Builder)BrandDefinition.builder().applyMutation(brandDefinition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

