/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeRangeDrillDownFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeRangeDrillDownFilter> {
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(TimeRangeDrillDownFilter.getter(TimeRangeDrillDownFilter::column)).setter(TimeRangeDrillDownFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Instant> RANGE_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RangeMinimum").getter(TimeRangeDrillDownFilter.getter(TimeRangeDrillDownFilter::rangeMinimum)).setter(TimeRangeDrillDownFilter.setter(Builder::rangeMinimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimum").build()}).build();
    private static final SdkField<Instant> RANGE_MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RangeMaximum").getter(TimeRangeDrillDownFilter.getter(TimeRangeDrillDownFilter::rangeMaximum)).setter(TimeRangeDrillDownFilter.setter(Builder::rangeMaximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximum").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TimeRangeDrillDownFilter.getter(TimeRangeDrillDownFilter::timeGranularityAsString)).setter(TimeRangeDrillDownFilter.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, RANGE_MINIMUM_FIELD, RANGE_MAXIMUM_FIELD, TIME_GRANULARITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeRangeDrillDownFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ColumnIdentifier column;
    private final Instant rangeMinimum;
    private final Instant rangeMaximum;
    private final String timeGranularity;

    private TimeRangeDrillDownFilter(BuilderImpl builder) {
        this.column = builder.column;
        this.rangeMinimum = builder.rangeMinimum;
        this.rangeMaximum = builder.rangeMaximum;
        this.timeGranularity = builder.timeGranularity;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Instant rangeMinimum() {
        return this.rangeMinimum;
    }

    public final Instant rangeMaximum() {
        return this.rangeMaximum;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeDrillDownFilter)) {
            return false;
        }
        TimeRangeDrillDownFilter other = (TimeRangeDrillDownFilter)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.rangeMinimum(), other.rangeMinimum()) && Objects.equals(this.rangeMaximum(), other.rangeMaximum()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TimeRangeDrillDownFilter").add("Column", (Object)this.column()).add("RangeMinimum", (Object)this.rangeMinimum()).add("RangeMaximum", (Object)this.rangeMaximum()).add("TimeGranularity", (Object)this.timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "RangeMinimum": {
                return Optional.ofNullable(clazz.cast(this.rangeMinimum()));
            }
            case "RangeMaximum": {
                return Optional.ofNullable(clazz.cast(this.rangeMaximum()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Column", COLUMN_FIELD);
        map.put("RangeMinimum", RANGE_MINIMUM_FIELD);
        map.put("RangeMaximum", RANGE_MAXIMUM_FIELD);
        map.put("TimeGranularity", TIME_GRANULARITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeDrillDownFilter, T> g) {
        return obj -> g.apply((TimeRangeDrillDownFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ColumnIdentifier column;
        private Instant rangeMinimum;
        private Instant rangeMaximum;
        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeDrillDownFilter model) {
            this.column(model.column);
            this.rangeMinimum(model.rangeMinimum);
            this.rangeMaximum(model.rangeMaximum);
            this.timeGranularity(model.timeGranularity);
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Instant getRangeMinimum() {
            return this.rangeMinimum;
        }

        public final void setRangeMinimum(Instant rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
        }

        @Override
        public final Builder rangeMinimum(Instant rangeMinimum) {
            this.rangeMinimum = rangeMinimum;
            return this;
        }

        public final Instant getRangeMaximum() {
            return this.rangeMaximum;
        }

        public final void setRangeMaximum(Instant rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
        }

        @Override
        public final Builder rangeMaximum(Instant rangeMaximum) {
            this.rangeMaximum = rangeMaximum;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public TimeRangeDrillDownFilter build() {
            return new TimeRangeDrillDownFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeRangeDrillDownFilter> {
        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder rangeMinimum(Instant var1);

        public Builder rangeMaximum(Instant var1);

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);
    }
}

