/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.TopicRefreshScheduleSummariesCopier;
import software.amazon.awssdk.services.quicksight.model.TopicRefreshScheduleSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTopicRefreshSchedulesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListTopicRefreshSchedulesResponse> {
    private static final SdkField<String> TOPIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicId").getter(ListTopicRefreshSchedulesResponse.getter(ListTopicRefreshSchedulesResponse::topicId)).setter(ListTopicRefreshSchedulesResponse.setter(Builder::topicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicId").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(ListTopicRefreshSchedulesResponse.getter(ListTopicRefreshSchedulesResponse::topicArn)).setter(ListTopicRefreshSchedulesResponse.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<List<TopicRefreshScheduleSummary>> REFRESH_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RefreshSchedules").getter(ListTopicRefreshSchedulesResponse.getter(ListTopicRefreshSchedulesResponse::refreshSchedules)).setter(ListTopicRefreshSchedulesResponse.setter(Builder::refreshSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TopicRefreshScheduleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListTopicRefreshSchedulesResponse.getter(ListTopicRefreshSchedulesResponse::status)).setter(ListTopicRefreshSchedulesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListTopicRefreshSchedulesResponse.getter(ListTopicRefreshSchedulesResponse::requestId)).setter(ListTopicRefreshSchedulesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ID_FIELD, TOPIC_ARN_FIELD, REFRESH_SCHEDULES_FIELD, STATUS_FIELD, REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTopicRefreshSchedulesResponse.memberNameToFieldInitializer();
    private final String topicId;
    private final String topicArn;
    private final List<TopicRefreshScheduleSummary> refreshSchedules;
    private final Integer status;
    private final String requestId;

    private ListTopicRefreshSchedulesResponse(BuilderImpl builder) {
        super(builder);
        this.topicId = builder.topicId;
        this.topicArn = builder.topicArn;
        this.refreshSchedules = builder.refreshSchedules;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    public final String topicId() {
        return this.topicId;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final boolean hasRefreshSchedules() {
        return this.refreshSchedules != null && !(this.refreshSchedules instanceof SdkAutoConstructList);
    }

    public final List<TopicRefreshScheduleSummary> refreshSchedules() {
        return this.refreshSchedules;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRefreshSchedules() ? this.refreshSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRefreshSchedulesResponse)) {
            return false;
        }
        ListTopicRefreshSchedulesResponse other = (ListTopicRefreshSchedulesResponse)((Object)obj);
        return Objects.equals(this.topicId(), other.topicId()) && Objects.equals(this.topicArn(), other.topicArn()) && this.hasRefreshSchedules() == other.hasRefreshSchedules() && Objects.equals(this.refreshSchedules(), other.refreshSchedules()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId());
    }

    public final String toString() {
        return ToString.builder((String)"ListTopicRefreshSchedulesResponse").add("TopicId", (Object)this.topicId()).add("TopicArn", (Object)this.topicArn()).add("RefreshSchedules", this.hasRefreshSchedules() ? this.refreshSchedules() : null).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicId": {
                return Optional.ofNullable(clazz.cast(this.topicId()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "RefreshSchedules": {
                return Optional.ofNullable(clazz.cast(this.refreshSchedules()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TopicId", TOPIC_ID_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("RefreshSchedules", REFRESH_SCHEDULES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RequestId", REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTopicRefreshSchedulesResponse, T> g) {
        return obj -> g.apply((ListTopicRefreshSchedulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String topicId;
        private String topicArn;
        private List<TopicRefreshScheduleSummary> refreshSchedules = DefaultSdkAutoConstructList.getInstance();
        private Integer status;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRefreshSchedulesResponse model) {
            super(model);
            this.topicId(model.topicId);
            this.topicArn(model.topicArn);
            this.refreshSchedules(model.refreshSchedules);
            this.status(model.status);
            this.requestId(model.requestId);
        }

        public final String getTopicId() {
            return this.topicId;
        }

        public final void setTopicId(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public final Builder topicId(String topicId) {
            this.topicId = topicId;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final List<TopicRefreshScheduleSummary.Builder> getRefreshSchedules() {
            List<TopicRefreshScheduleSummary.Builder> result = TopicRefreshScheduleSummariesCopier.copyToBuilder(this.refreshSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRefreshSchedules(Collection<TopicRefreshScheduleSummary.BuilderImpl> refreshSchedules) {
            this.refreshSchedules = TopicRefreshScheduleSummariesCopier.copyFromBuilder(refreshSchedules);
        }

        @Override
        public final Builder refreshSchedules(Collection<TopicRefreshScheduleSummary> refreshSchedules) {
            this.refreshSchedules = TopicRefreshScheduleSummariesCopier.copy(refreshSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(TopicRefreshScheduleSummary ... refreshSchedules) {
            this.refreshSchedules(Arrays.asList(refreshSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder refreshSchedules(Consumer<TopicRefreshScheduleSummary.Builder> ... refreshSchedules) {
            this.refreshSchedules(Stream.of(refreshSchedules).map(c -> (TopicRefreshScheduleSummary)((TopicRefreshScheduleSummary.Builder)TopicRefreshScheduleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public ListTopicRefreshSchedulesResponse build() {
            return new ListTopicRefreshSchedulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTopicRefreshSchedulesResponse> {
        public Builder topicId(String var1);

        public Builder topicArn(String var1);

        public Builder refreshSchedules(Collection<TopicRefreshScheduleSummary> var1);

        public Builder refreshSchedules(TopicRefreshScheduleSummary ... var1);

        public Builder refreshSchedules(Consumer<TopicRefreshScheduleSummary.Builder> ... var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);
    }
}

