/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The word cloud options for a word cloud visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WordCloudOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<WordCloudOptions.Builder, WordCloudOptions> {
    private static final SdkField<String> WORD_ORIENTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WordOrientation").getter(getter(WordCloudOptions::wordOrientationAsString))
            .setter(setter(Builder::wordOrientation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordOrientation").build()).build();

    private static final SdkField<String> WORD_SCALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WordScaling").getter(getter(WordCloudOptions::wordScalingAsString)).setter(setter(Builder::wordScaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordScaling").build()).build();

    private static final SdkField<String> CLOUD_LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudLayout").getter(getter(WordCloudOptions::cloudLayoutAsString)).setter(setter(Builder::cloudLayout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudLayout").build()).build();

    private static final SdkField<String> WORD_CASING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WordCasing").getter(getter(WordCloudOptions::wordCasingAsString)).setter(setter(Builder::wordCasing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCasing").build()).build();

    private static final SdkField<String> WORD_PADDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WordPadding").getter(getter(WordCloudOptions::wordPaddingAsString)).setter(setter(Builder::wordPadding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordPadding").build()).build();

    private static final SdkField<Integer> MAXIMUM_STRING_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumStringLength").getter(getter(WordCloudOptions::maximumStringLength))
            .setter(setter(Builder::maximumStringLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumStringLength").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORD_ORIENTATION_FIELD,
            WORD_SCALING_FIELD, CLOUD_LAYOUT_FIELD, WORD_CASING_FIELD, WORD_PADDING_FIELD, MAXIMUM_STRING_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String wordOrientation;

    private final String wordScaling;

    private final String cloudLayout;

    private final String wordCasing;

    private final String wordPadding;

    private final Integer maximumStringLength;

    private WordCloudOptions(BuilderImpl builder) {
        this.wordOrientation = builder.wordOrientation;
        this.wordScaling = builder.wordScaling;
        this.cloudLayout = builder.cloudLayout;
        this.wordCasing = builder.wordCasing;
        this.wordPadding = builder.wordPadding;
        this.maximumStringLength = builder.maximumStringLength;
    }

    /**
     * <p>
     * The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordOrientation}
     * will return {@link WordCloudWordOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #wordOrientationAsString}.
     * </p>
     * 
     * @return The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
     * @see WordCloudWordOrientation
     */
    public final WordCloudWordOrientation wordOrientation() {
        return WordCloudWordOrientation.fromValue(wordOrientation);
    }

    /**
     * <p>
     * The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordOrientation}
     * will return {@link WordCloudWordOrientation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #wordOrientationAsString}.
     * </p>
     * 
     * @return The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
     * @see WordCloudWordOrientation
     */
    public final String wordOrientationAsString() {
        return wordOrientation;
    }

    /**
     * <p>
     * The word scaling options (emphasize, normal) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordScaling} will
     * return {@link WordCloudWordScaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordScalingAsString}.
     * </p>
     * 
     * @return The word scaling options (emphasize, normal) for the words in a word cloud.
     * @see WordCloudWordScaling
     */
    public final WordCloudWordScaling wordScaling() {
        return WordCloudWordScaling.fromValue(wordScaling);
    }

    /**
     * <p>
     * The word scaling options (emphasize, normal) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordScaling} will
     * return {@link WordCloudWordScaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordScalingAsString}.
     * </p>
     * 
     * @return The word scaling options (emphasize, normal) for the words in a word cloud.
     * @see WordCloudWordScaling
     */
    public final String wordScalingAsString() {
        return wordScaling;
    }

    /**
     * <p>
     * The cloud layout options (fluid, normal) of a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cloudLayout} will
     * return {@link WordCloudCloudLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cloudLayoutAsString}.
     * </p>
     * 
     * @return The cloud layout options (fluid, normal) of a word cloud.
     * @see WordCloudCloudLayout
     */
    public final WordCloudCloudLayout cloudLayout() {
        return WordCloudCloudLayout.fromValue(cloudLayout);
    }

    /**
     * <p>
     * The cloud layout options (fluid, normal) of a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cloudLayout} will
     * return {@link WordCloudCloudLayout#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cloudLayoutAsString}.
     * </p>
     * 
     * @return The cloud layout options (fluid, normal) of a word cloud.
     * @see WordCloudCloudLayout
     */
    public final String cloudLayoutAsString() {
        return cloudLayout;
    }

    /**
     * <p>
     * The word casing options (lower_case, existing_case) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordCasing} will
     * return {@link WordCloudWordCasing#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordCasingAsString}.
     * </p>
     * 
     * @return The word casing options (lower_case, existing_case) for the words in a word cloud.
     * @see WordCloudWordCasing
     */
    public final WordCloudWordCasing wordCasing() {
        return WordCloudWordCasing.fromValue(wordCasing);
    }

    /**
     * <p>
     * The word casing options (lower_case, existing_case) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordCasing} will
     * return {@link WordCloudWordCasing#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordCasingAsString}.
     * </p>
     * 
     * @return The word casing options (lower_case, existing_case) for the words in a word cloud.
     * @see WordCloudWordCasing
     */
    public final String wordCasingAsString() {
        return wordCasing;
    }

    /**
     * <p>
     * The word padding options (none, small, medium, large) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordPadding} will
     * return {@link WordCloudWordPadding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordPaddingAsString}.
     * </p>
     * 
     * @return The word padding options (none, small, medium, large) for the words in a word cloud.
     * @see WordCloudWordPadding
     */
    public final WordCloudWordPadding wordPadding() {
        return WordCloudWordPadding.fromValue(wordPadding);
    }

    /**
     * <p>
     * The word padding options (none, small, medium, large) for the words in a word cloud.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #wordPadding} will
     * return {@link WordCloudWordPadding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #wordPaddingAsString}.
     * </p>
     * 
     * @return The word padding options (none, small, medium, large) for the words in a word cloud.
     * @see WordCloudWordPadding
     */
    public final String wordPaddingAsString() {
        return wordPadding;
    }

    /**
     * <p>
     * The length limit of each word from 1-100.
     * </p>
     * 
     * @return The length limit of each word from 1-100.
     */
    public final Integer maximumStringLength() {
        return maximumStringLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(wordOrientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wordScalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cloudLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wordCasingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wordPaddingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumStringLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudOptions)) {
            return false;
        }
        WordCloudOptions other = (WordCloudOptions) obj;
        return Objects.equals(wordOrientationAsString(), other.wordOrientationAsString())
                && Objects.equals(wordScalingAsString(), other.wordScalingAsString())
                && Objects.equals(cloudLayoutAsString(), other.cloudLayoutAsString())
                && Objects.equals(wordCasingAsString(), other.wordCasingAsString())
                && Objects.equals(wordPaddingAsString(), other.wordPaddingAsString())
                && Objects.equals(maximumStringLength(), other.maximumStringLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WordCloudOptions").add("WordOrientation", wordOrientationAsString())
                .add("WordScaling", wordScalingAsString()).add("CloudLayout", cloudLayoutAsString())
                .add("WordCasing", wordCasingAsString()).add("WordPadding", wordPaddingAsString())
                .add("MaximumStringLength", maximumStringLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WordOrientation":
            return Optional.ofNullable(clazz.cast(wordOrientationAsString()));
        case "WordScaling":
            return Optional.ofNullable(clazz.cast(wordScalingAsString()));
        case "CloudLayout":
            return Optional.ofNullable(clazz.cast(cloudLayoutAsString()));
        case "WordCasing":
            return Optional.ofNullable(clazz.cast(wordCasingAsString()));
        case "WordPadding":
            return Optional.ofNullable(clazz.cast(wordPaddingAsString()));
        case "MaximumStringLength":
            return Optional.ofNullable(clazz.cast(maximumStringLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WordOrientation", WORD_ORIENTATION_FIELD);
        map.put("WordScaling", WORD_SCALING_FIELD);
        map.put("CloudLayout", CLOUD_LAYOUT_FIELD);
        map.put("WordCasing", WORD_CASING_FIELD);
        map.put("WordPadding", WORD_PADDING_FIELD);
        map.put("MaximumStringLength", MAXIMUM_STRING_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WordCloudOptions, T> g) {
        return obj -> g.apply((WordCloudOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WordCloudOptions> {
        /**
         * <p>
         * The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
         * </p>
         * 
         * @param wordOrientation
         *        The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
         * @see WordCloudWordOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordOrientation
         */
        Builder wordOrientation(String wordOrientation);

        /**
         * <p>
         * The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
         * </p>
         * 
         * @param wordOrientation
         *        The word orientation options (horizontal, horizontal_and_vertical) for the words in a word cloud.
         * @see WordCloudWordOrientation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordOrientation
         */
        Builder wordOrientation(WordCloudWordOrientation wordOrientation);

        /**
         * <p>
         * The word scaling options (emphasize, normal) for the words in a word cloud.
         * </p>
         * 
         * @param wordScaling
         *        The word scaling options (emphasize, normal) for the words in a word cloud.
         * @see WordCloudWordScaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordScaling
         */
        Builder wordScaling(String wordScaling);

        /**
         * <p>
         * The word scaling options (emphasize, normal) for the words in a word cloud.
         * </p>
         * 
         * @param wordScaling
         *        The word scaling options (emphasize, normal) for the words in a word cloud.
         * @see WordCloudWordScaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordScaling
         */
        Builder wordScaling(WordCloudWordScaling wordScaling);

        /**
         * <p>
         * The cloud layout options (fluid, normal) of a word cloud.
         * </p>
         * 
         * @param cloudLayout
         *        The cloud layout options (fluid, normal) of a word cloud.
         * @see WordCloudCloudLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudCloudLayout
         */
        Builder cloudLayout(String cloudLayout);

        /**
         * <p>
         * The cloud layout options (fluid, normal) of a word cloud.
         * </p>
         * 
         * @param cloudLayout
         *        The cloud layout options (fluid, normal) of a word cloud.
         * @see WordCloudCloudLayout
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudCloudLayout
         */
        Builder cloudLayout(WordCloudCloudLayout cloudLayout);

        /**
         * <p>
         * The word casing options (lower_case, existing_case) for the words in a word cloud.
         * </p>
         * 
         * @param wordCasing
         *        The word casing options (lower_case, existing_case) for the words in a word cloud.
         * @see WordCloudWordCasing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordCasing
         */
        Builder wordCasing(String wordCasing);

        /**
         * <p>
         * The word casing options (lower_case, existing_case) for the words in a word cloud.
         * </p>
         * 
         * @param wordCasing
         *        The word casing options (lower_case, existing_case) for the words in a word cloud.
         * @see WordCloudWordCasing
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordCasing
         */
        Builder wordCasing(WordCloudWordCasing wordCasing);

        /**
         * <p>
         * The word padding options (none, small, medium, large) for the words in a word cloud.
         * </p>
         * 
         * @param wordPadding
         *        The word padding options (none, small, medium, large) for the words in a word cloud.
         * @see WordCloudWordPadding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordPadding
         */
        Builder wordPadding(String wordPadding);

        /**
         * <p>
         * The word padding options (none, small, medium, large) for the words in a word cloud.
         * </p>
         * 
         * @param wordPadding
         *        The word padding options (none, small, medium, large) for the words in a word cloud.
         * @see WordCloudWordPadding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WordCloudWordPadding
         */
        Builder wordPadding(WordCloudWordPadding wordPadding);

        /**
         * <p>
         * The length limit of each word from 1-100.
         * </p>
         * 
         * @param maximumStringLength
         *        The length limit of each word from 1-100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumStringLength(Integer maximumStringLength);
    }

    static final class BuilderImpl implements Builder {
        private String wordOrientation;

        private String wordScaling;

        private String cloudLayout;

        private String wordCasing;

        private String wordPadding;

        private Integer maximumStringLength;

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudOptions model) {
            wordOrientation(model.wordOrientation);
            wordScaling(model.wordScaling);
            cloudLayout(model.cloudLayout);
            wordCasing(model.wordCasing);
            wordPadding(model.wordPadding);
            maximumStringLength(model.maximumStringLength);
        }

        public final String getWordOrientation() {
            return wordOrientation;
        }

        public final void setWordOrientation(String wordOrientation) {
            this.wordOrientation = wordOrientation;
        }

        @Override
        public final Builder wordOrientation(String wordOrientation) {
            this.wordOrientation = wordOrientation;
            return this;
        }

        @Override
        public final Builder wordOrientation(WordCloudWordOrientation wordOrientation) {
            this.wordOrientation(wordOrientation == null ? null : wordOrientation.toString());
            return this;
        }

        public final String getWordScaling() {
            return wordScaling;
        }

        public final void setWordScaling(String wordScaling) {
            this.wordScaling = wordScaling;
        }

        @Override
        public final Builder wordScaling(String wordScaling) {
            this.wordScaling = wordScaling;
            return this;
        }

        @Override
        public final Builder wordScaling(WordCloudWordScaling wordScaling) {
            this.wordScaling(wordScaling == null ? null : wordScaling.toString());
            return this;
        }

        public final String getCloudLayout() {
            return cloudLayout;
        }

        public final void setCloudLayout(String cloudLayout) {
            this.cloudLayout = cloudLayout;
        }

        @Override
        public final Builder cloudLayout(String cloudLayout) {
            this.cloudLayout = cloudLayout;
            return this;
        }

        @Override
        public final Builder cloudLayout(WordCloudCloudLayout cloudLayout) {
            this.cloudLayout(cloudLayout == null ? null : cloudLayout.toString());
            return this;
        }

        public final String getWordCasing() {
            return wordCasing;
        }

        public final void setWordCasing(String wordCasing) {
            this.wordCasing = wordCasing;
        }

        @Override
        public final Builder wordCasing(String wordCasing) {
            this.wordCasing = wordCasing;
            return this;
        }

        @Override
        public final Builder wordCasing(WordCloudWordCasing wordCasing) {
            this.wordCasing(wordCasing == null ? null : wordCasing.toString());
            return this;
        }

        public final String getWordPadding() {
            return wordPadding;
        }

        public final void setWordPadding(String wordPadding) {
            this.wordPadding = wordPadding;
        }

        @Override
        public final Builder wordPadding(String wordPadding) {
            this.wordPadding = wordPadding;
            return this;
        }

        @Override
        public final Builder wordPadding(WordCloudWordPadding wordPadding) {
            this.wordPadding(wordPadding == null ? null : wordPadding.toString());
            return this;
        }

        public final Integer getMaximumStringLength() {
            return maximumStringLength;
        }

        public final void setMaximumStringLength(Integer maximumStringLength) {
            this.maximumStringLength = maximumStringLength;
        }

        @Override
        public final Builder maximumStringLength(Integer maximumStringLength) {
            this.maximumStringLength = maximumStringLength;
            return this;
        }

        @Override
        public WordCloudOptions build() {
            return new WordCloudOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
