/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for a <code>Topic</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TopicConfigOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TopicConfigOptions.Builder, TopicConfigOptions> {
    private static final SdkField<Boolean> Q_BUSINESS_INSIGHTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("QBusinessInsightsEnabled")
            .getter(getter(TopicConfigOptions::qBusinessInsightsEnabled)).setter(setter(Builder::qBusinessInsightsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QBusinessInsightsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(Q_BUSINESS_INSIGHTS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean qBusinessInsightsEnabled;

    private TopicConfigOptions(BuilderImpl builder) {
        this.qBusinessInsightsEnabled = builder.qBusinessInsightsEnabled;
    }

    /**
     * <p>
     * Enables Amazon Q Business Insights for a <code>Topic</code>.
     * </p>
     * 
     * @return Enables Amazon Q Business Insights for a <code>Topic</code>.
     */
    public final Boolean qBusinessInsightsEnabled() {
        return qBusinessInsightsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(qBusinessInsightsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigOptions)) {
            return false;
        }
        TopicConfigOptions other = (TopicConfigOptions) obj;
        return Objects.equals(qBusinessInsightsEnabled(), other.qBusinessInsightsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TopicConfigOptions").add("QBusinessInsightsEnabled", qBusinessInsightsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QBusinessInsightsEnabled":
            return Optional.ofNullable(clazz.cast(qBusinessInsightsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QBusinessInsightsEnabled", Q_BUSINESS_INSIGHTS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicConfigOptions, T> g) {
        return obj -> g.apply((TopicConfigOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TopicConfigOptions> {
        /**
         * <p>
         * Enables Amazon Q Business Insights for a <code>Topic</code>.
         * </p>
         * 
         * @param qBusinessInsightsEnabled
         *        Enables Amazon Q Business Insights for a <code>Topic</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qBusinessInsightsEnabled(Boolean qBusinessInsightsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean qBusinessInsightsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigOptions model) {
            qBusinessInsightsEnabled(model.qBusinessInsightsEnabled);
        }

        public final Boolean getQBusinessInsightsEnabled() {
            return qBusinessInsightsEnabled;
        }

        public final void setQBusinessInsightsEnabled(Boolean qBusinessInsightsEnabled) {
            this.qBusinessInsightsEnabled = qBusinessInsightsEnabled;
        }

        @Override
        public final Builder qBusinessInsightsEnabled(Boolean qBusinessInsightsEnabled) {
            this.qBusinessInsightsEnabled = qBusinessInsightsEnabled;
            return this;
        }

        @Override
        public TopicConfigOptions build() {
            return new TopicConfigOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
