/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A static file that contains the geospatial data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpatialStaticFile implements SdkPojo, Serializable,
        ToCopyableBuilder<SpatialStaticFile.Builder, SpatialStaticFile> {
    private static final SdkField<String> STATIC_FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StaticFileId").getter(getter(SpatialStaticFile::staticFileId)).setter(setter(Builder::staticFileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticFileId").build()).build();

    private static final SdkField<StaticFileSource> SOURCE_FIELD = SdkField.<StaticFileSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(SpatialStaticFile::source)).setter(setter(Builder::source))
            .constructor(StaticFileSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_FILE_ID_FIELD,
            SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String staticFileId;

    private final StaticFileSource source;

    private SpatialStaticFile(BuilderImpl builder) {
        this.staticFileId = builder.staticFileId;
        this.source = builder.source;
    }

    /**
     * <p>
     * The ID of the spatial static file.
     * </p>
     * 
     * @return The ID of the spatial static file.
     */
    public final String staticFileId() {
        return staticFileId;
    }

    /**
     * <p>
     * The source of the spatial static file.
     * </p>
     * 
     * @return The source of the spatial static file.
     */
    public final StaticFileSource source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticFileId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpatialStaticFile)) {
            return false;
        }
        SpatialStaticFile other = (SpatialStaticFile) obj;
        return Objects.equals(staticFileId(), other.staticFileId()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpatialStaticFile").add("StaticFileId", staticFileId()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticFileId":
            return Optional.ofNullable(clazz.cast(staticFileId()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StaticFileId", STATIC_FILE_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpatialStaticFile, T> g) {
        return obj -> g.apply((SpatialStaticFile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpatialStaticFile> {
        /**
         * <p>
         * The ID of the spatial static file.
         * </p>
         * 
         * @param staticFileId
         *        The ID of the spatial static file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticFileId(String staticFileId);

        /**
         * <p>
         * The source of the spatial static file.
         * </p>
         * 
         * @param source
         *        The source of the spatial static file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(StaticFileSource source);

        /**
         * <p>
         * The source of the spatial static file.
         * </p>
         * This is a convenience method that creates an instance of the {@link StaticFileSource.Builder} avoiding the
         * need to create one manually via {@link StaticFileSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StaticFileSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(StaticFileSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link StaticFileSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(StaticFileSource)
         */
        default Builder source(Consumer<StaticFileSource.Builder> source) {
            return source(StaticFileSource.builder().applyMutation(source).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String staticFileId;

        private StaticFileSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(SpatialStaticFile model) {
            staticFileId(model.staticFileId);
            source(model.source);
        }

        public final String getStaticFileId() {
            return staticFileId;
        }

        public final void setStaticFileId(String staticFileId) {
            this.staticFileId = staticFileId;
        }

        @Override
        public final Builder staticFileId(String staticFileId) {
            this.staticFileId = staticFileId;
            return this;
        }

        public final StaticFileSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(StaticFileSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(StaticFileSource source) {
            this.source = source;
            return this;
        }

        @Override
        public SpatialStaticFile build() {
            return new SpatialStaticFile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
