/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of spacing (often a margin or padding).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Spacing implements SdkPojo, Serializable, ToCopyableBuilder<Spacing.Builder, Spacing> {
    private static final SdkField<String> TOP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Top")
            .getter(getter(Spacing::top)).setter(setter(Builder::top))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Top").build()).build();

    private static final SdkField<String> BOTTOM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bottom")
            .getter(getter(Spacing::bottom)).setter(setter(Builder::bottom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bottom").build()).build();

    private static final SdkField<String> LEFT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Left")
            .getter(getter(Spacing::left)).setter(setter(Builder::left))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Left").build()).build();

    private static final SdkField<String> RIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Right")
            .getter(getter(Spacing::right)).setter(setter(Builder::right))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Right").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOP_FIELD, BOTTOM_FIELD,
            LEFT_FIELD, RIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String top;

    private final String bottom;

    private final String left;

    private final String right;

    private Spacing(BuilderImpl builder) {
        this.top = builder.top;
        this.bottom = builder.bottom;
        this.left = builder.left;
        this.right = builder.right;
    }

    /**
     * <p>
     * Define the top spacing.
     * </p>
     * 
     * @return Define the top spacing.
     */
    public final String top() {
        return top;
    }

    /**
     * <p>
     * Define the bottom spacing.
     * </p>
     * 
     * @return Define the bottom spacing.
     */
    public final String bottom() {
        return bottom;
    }

    /**
     * <p>
     * Define the left spacing.
     * </p>
     * 
     * @return Define the left spacing.
     */
    public final String left() {
        return left;
    }

    /**
     * <p>
     * Define the right spacing.
     * </p>
     * 
     * @return Define the right spacing.
     */
    public final String right() {
        return right;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(top());
        hashCode = 31 * hashCode + Objects.hashCode(bottom());
        hashCode = 31 * hashCode + Objects.hashCode(left());
        hashCode = 31 * hashCode + Objects.hashCode(right());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Spacing)) {
            return false;
        }
        Spacing other = (Spacing) obj;
        return Objects.equals(top(), other.top()) && Objects.equals(bottom(), other.bottom())
                && Objects.equals(left(), other.left()) && Objects.equals(right(), other.right());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Spacing").add("Top", top()).add("Bottom", bottom()).add("Left", left()).add("Right", right())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Top":
            return Optional.ofNullable(clazz.cast(top()));
        case "Bottom":
            return Optional.ofNullable(clazz.cast(bottom()));
        case "Left":
            return Optional.ofNullable(clazz.cast(left()));
        case "Right":
            return Optional.ofNullable(clazz.cast(right()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Top", TOP_FIELD);
        map.put("Bottom", BOTTOM_FIELD);
        map.put("Left", LEFT_FIELD);
        map.put("Right", RIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Spacing, T> g) {
        return obj -> g.apply((Spacing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Spacing> {
        /**
         * <p>
         * Define the top spacing.
         * </p>
         * 
         * @param top
         *        Define the top spacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder top(String top);

        /**
         * <p>
         * Define the bottom spacing.
         * </p>
         * 
         * @param bottom
         *        Define the bottom spacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bottom(String bottom);

        /**
         * <p>
         * Define the left spacing.
         * </p>
         * 
         * @param left
         *        Define the left spacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder left(String left);

        /**
         * <p>
         * Define the right spacing.
         * </p>
         * 
         * @param right
         *        Define the right spacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder right(String right);
    }

    static final class BuilderImpl implements Builder {
        private String top;

        private String bottom;

        private String left;

        private String right;

        private BuilderImpl() {
        }

        private BuilderImpl(Spacing model) {
            top(model.top);
            bottom(model.bottom);
            left(model.left);
            right(model.right);
        }

        public final String getTop() {
            return top;
        }

        public final void setTop(String top) {
            this.top = top;
        }

        @Override
        public final Builder top(String top) {
            this.top = top;
            return this;
        }

        public final String getBottom() {
            return bottom;
        }

        public final void setBottom(String bottom) {
            this.bottom = bottom;
        }

        @Override
        public final Builder bottom(String bottom) {
            this.bottom = bottom;
            return this;
        }

        public final String getLeft() {
            return left;
        }

        public final void setLeft(String left) {
            this.left = left;
        }

        @Override
        public final Builder left(String left) {
            this.left = left;
            return this;
        }

        public final String getRight() {
            return right;
        }

        public final void setRight(String right) {
            this.right = right;
        }

        @Override
        public final Builder right(String right) {
            this.right = right;
            return this;
        }

        @Override
        public Spacing build() {
            return new Spacing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
