/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of logos.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogoSet implements SdkPojo, Serializable, ToCopyableBuilder<LogoSet.Builder, LogoSet> {
    private static final SdkField<ImageSet> PRIMARY_FIELD = SdkField.<ImageSet> builder(MarshallingType.SDK_POJO)
            .memberName("Primary").getter(getter(LogoSet::primary)).setter(setter(Builder::primary))
            .constructor(ImageSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<ImageSet> FAVICON_FIELD = SdkField.<ImageSet> builder(MarshallingType.SDK_POJO)
            .memberName("Favicon").getter(getter(LogoSet::favicon)).setter(setter(Builder::favicon))
            .constructor(ImageSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Favicon").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_FIELD, FAVICON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageSet primary;

    private final ImageSet favicon;

    private LogoSet(BuilderImpl builder) {
        this.primary = builder.primary;
        this.favicon = builder.favicon;
    }

    /**
     * <p>
     * The primary logo.
     * </p>
     * 
     * @return The primary logo.
     */
    public final ImageSet primary() {
        return primary;
    }

    /**
     * <p>
     * The favicon logo.
     * </p>
     * 
     * @return The favicon logo.
     */
    public final ImageSet favicon() {
        return favicon;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(favicon());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogoSet)) {
            return false;
        }
        LogoSet other = (LogoSet) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(favicon(), other.favicon());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogoSet").add("Primary", primary()).add("Favicon", favicon()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Favicon":
            return Optional.ofNullable(clazz.cast(favicon()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Primary", PRIMARY_FIELD);
        map.put("Favicon", FAVICON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogoSet, T> g) {
        return obj -> g.apply((LogoSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogoSet> {
        /**
         * <p>
         * The primary logo.
         * </p>
         * 
         * @param primary
         *        The primary logo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(ImageSet primary);

        /**
         * <p>
         * The primary logo.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSet.Builder} avoiding the need to
         * create one manually via {@link ImageSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSet.Builder#build()} is called immediately and its result is
         * passed to {@link #primary(ImageSet)}.
         * 
         * @param primary
         *        a consumer that will call methods on {@link ImageSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(ImageSet)
         */
        default Builder primary(Consumer<ImageSet.Builder> primary) {
            return primary(ImageSet.builder().applyMutation(primary).build());
        }

        /**
         * <p>
         * The favicon logo.
         * </p>
         * 
         * @param favicon
         *        The favicon logo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder favicon(ImageSet favicon);

        /**
         * <p>
         * The favicon logo.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSet.Builder} avoiding the need to
         * create one manually via {@link ImageSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSet.Builder#build()} is called immediately and its result is
         * passed to {@link #favicon(ImageSet)}.
         * 
         * @param favicon
         *        a consumer that will call methods on {@link ImageSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #favicon(ImageSet)
         */
        default Builder favicon(Consumer<ImageSet.Builder> favicon) {
            return favicon(ImageSet.builder().applyMutation(favicon).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageSet primary;

        private ImageSet favicon;

        private BuilderImpl() {
        }

        private BuilderImpl(LogoSet model) {
            primary(model.primary);
            favicon(model.favicon);
        }

        public final ImageSet.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(ImageSet.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(ImageSet primary) {
            this.primary = primary;
            return this;
        }

        public final ImageSet.Builder getFavicon() {
            return favicon != null ? favicon.toBuilder() : null;
        }

        public final void setFavicon(ImageSet.BuilderImpl favicon) {
            this.favicon = favicon != null ? favicon.build() : null;
        }

        @Override
        public final Builder favicon(ImageSet favicon) {
            this.favicon = favicon;
            return this;
        }

        @Override
        public LogoSet build() {
            return new LogoSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
