/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The map state properties for a map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialMapState implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialMapState.Builder, GeospatialMapState> {
    private static final SdkField<GeospatialCoordinateBounds> BOUNDS_FIELD = SdkField
            .<GeospatialCoordinateBounds> builder(MarshallingType.SDK_POJO).memberName("Bounds")
            .getter(getter(GeospatialMapState::bounds)).setter(setter(Builder::bounds))
            .constructor(GeospatialCoordinateBounds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bounds").build()).build();

    private static final SdkField<String> MAP_NAVIGATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MapNavigation").getter(getter(GeospatialMapState::mapNavigationAsString))
            .setter(setter(Builder::mapNavigation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapNavigation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNDS_FIELD,
            MAP_NAVIGATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GeospatialCoordinateBounds bounds;

    private final String mapNavigation;

    private GeospatialMapState(BuilderImpl builder) {
        this.bounds = builder.bounds;
        this.mapNavigation = builder.mapNavigation;
    }

    /**
     * Returns the value of the Bounds property for this object.
     * 
     * @return The value of the Bounds property for this object.
     */
    public final GeospatialCoordinateBounds bounds() {
        return bounds;
    }

    /**
     * <p>
     * Enables or disables map navigation for a map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mapNavigation}
     * will return {@link GeospatialMapNavigation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mapNavigationAsString}.
     * </p>
     * 
     * @return Enables or disables map navigation for a map.
     * @see GeospatialMapNavigation
     */
    public final GeospatialMapNavigation mapNavigation() {
        return GeospatialMapNavigation.fromValue(mapNavigation);
    }

    /**
     * <p>
     * Enables or disables map navigation for a map.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mapNavigation}
     * will return {@link GeospatialMapNavigation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #mapNavigationAsString}.
     * </p>
     * 
     * @return Enables or disables map navigation for a map.
     * @see GeospatialMapNavigation
     */
    public final String mapNavigationAsString() {
        return mapNavigation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bounds());
        hashCode = 31 * hashCode + Objects.hashCode(mapNavigationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialMapState)) {
            return false;
        }
        GeospatialMapState other = (GeospatialMapState) obj;
        return Objects.equals(bounds(), other.bounds()) && Objects.equals(mapNavigationAsString(), other.mapNavigationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialMapState").add("Bounds", bounds()).add("MapNavigation", mapNavigationAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bounds":
            return Optional.ofNullable(clazz.cast(bounds()));
        case "MapNavigation":
            return Optional.ofNullable(clazz.cast(mapNavigationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bounds", BOUNDS_FIELD);
        map.put("MapNavigation", MAP_NAVIGATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialMapState, T> g) {
        return obj -> g.apply((GeospatialMapState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialMapState> {
        /**
         * Sets the value of the Bounds property for this object.
         *
         * @param bounds
         *        The new value for the Bounds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounds(GeospatialCoordinateBounds bounds);

        /**
         * Sets the value of the Bounds property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GeospatialCoordinateBounds.Builder}
         * avoiding the need to create one manually via {@link GeospatialCoordinateBounds#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialCoordinateBounds.Builder#build()} is called immediately
         * and its result is passed to {@link #bounds(GeospatialCoordinateBounds)}.
         * 
         * @param bounds
         *        a consumer that will call methods on {@link GeospatialCoordinateBounds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bounds(GeospatialCoordinateBounds)
         */
        default Builder bounds(Consumer<GeospatialCoordinateBounds.Builder> bounds) {
            return bounds(GeospatialCoordinateBounds.builder().applyMutation(bounds).build());
        }

        /**
         * <p>
         * Enables or disables map navigation for a map.
         * </p>
         * 
         * @param mapNavigation
         *        Enables or disables map navigation for a map.
         * @see GeospatialMapNavigation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialMapNavigation
         */
        Builder mapNavigation(String mapNavigation);

        /**
         * <p>
         * Enables or disables map navigation for a map.
         * </p>
         * 
         * @param mapNavigation
         *        Enables or disables map navigation for a map.
         * @see GeospatialMapNavigation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialMapNavigation
         */
        Builder mapNavigation(GeospatialMapNavigation mapNavigation);
    }

    static final class BuilderImpl implements Builder {
        private GeospatialCoordinateBounds bounds;

        private String mapNavigation;

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialMapState model) {
            bounds(model.bounds);
            mapNavigation(model.mapNavigation);
        }

        public final GeospatialCoordinateBounds.Builder getBounds() {
            return bounds != null ? bounds.toBuilder() : null;
        }

        public final void setBounds(GeospatialCoordinateBounds.BuilderImpl bounds) {
            this.bounds = bounds != null ? bounds.build() : null;
        }

        @Override
        public final Builder bounds(GeospatialCoordinateBounds bounds) {
            this.bounds = bounds;
            return this;
        }

        public final String getMapNavigation() {
            return mapNavigation;
        }

        public final void setMapNavigation(String mapNavigation) {
            this.mapNavigation = mapNavigation;
        }

        @Override
        public final Builder mapNavigation(String mapNavigation) {
            this.mapNavigation = mapNavigation;
            return this;
        }

        @Override
        public final Builder mapNavigation(GeospatialMapNavigation mapNavigation) {
            this.mapNavigation(mapNavigation == null ? null : mapNavigation.toString());
            return this;
        }

        @Override
        public GeospatialMapState build() {
            return new GeospatialMapState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
