/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties for a single geospatial layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeospatialLayerItem implements SdkPojo, Serializable,
        ToCopyableBuilder<GeospatialLayerItem.Builder, GeospatialLayerItem> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerId").getter(getter(GeospatialLayerItem::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final SdkField<String> LAYER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerType").getter(getter(GeospatialLayerItem::layerTypeAsString)).setter(setter(Builder::layerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerType").build()).build();

    private static final SdkField<GeospatialDataSourceItem> DATA_SOURCE_FIELD = SdkField
            .<GeospatialDataSourceItem> builder(MarshallingType.SDK_POJO).memberName("DataSource")
            .getter(getter(GeospatialLayerItem::dataSource)).setter(setter(Builder::dataSource))
            .constructor(GeospatialDataSourceItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(GeospatialLayerItem::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(GeospatialLayerItem::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<GeospatialLayerDefinition> LAYER_DEFINITION_FIELD = SdkField
            .<GeospatialLayerDefinition> builder(MarshallingType.SDK_POJO).memberName("LayerDefinition")
            .getter(getter(GeospatialLayerItem::layerDefinition)).setter(setter(Builder::layerDefinition))
            .constructor(GeospatialLayerDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerDefinition").build()).build();

    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.<TooltipOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Tooltip").getter(getter(GeospatialLayerItem::tooltip)).setter(setter(Builder::tooltip))
            .constructor(TooltipOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()).build();

    private static final SdkField<GeospatialLayerJoinDefinition> JOIN_DEFINITION_FIELD = SdkField
            .<GeospatialLayerJoinDefinition> builder(MarshallingType.SDK_POJO).memberName("JoinDefinition")
            .getter(getter(GeospatialLayerItem::joinDefinition)).setter(setter(Builder::joinDefinition))
            .constructor(GeospatialLayerJoinDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinDefinition").build()).build();

    private static final SdkField<List<LayerCustomAction>> ACTIONS_FIELD = SdkField
            .<List<LayerCustomAction>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(GeospatialLayerItem::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LayerCustomAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(LayerCustomAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD,
            LAYER_TYPE_FIELD, DATA_SOURCE_FIELD, LABEL_FIELD, VISIBILITY_FIELD, LAYER_DEFINITION_FIELD, TOOLTIP_FIELD,
            JOIN_DEFINITION_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String layerId;

    private final String layerType;

    private final GeospatialDataSourceItem dataSource;

    private final String label;

    private final String visibility;

    private final GeospatialLayerDefinition layerDefinition;

    private final TooltipOptions tooltip;

    private final GeospatialLayerJoinDefinition joinDefinition;

    private final List<LayerCustomAction> actions;

    private GeospatialLayerItem(BuilderImpl builder) {
        this.layerId = builder.layerId;
        this.layerType = builder.layerType;
        this.dataSource = builder.dataSource;
        this.label = builder.label;
        this.visibility = builder.visibility;
        this.layerDefinition = builder.layerDefinition;
        this.tooltip = builder.tooltip;
        this.joinDefinition = builder.joinDefinition;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The ID of the layer.
     * </p>
     * 
     * @return The ID of the layer.
     */
    public final String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layerType} will
     * return {@link GeospatialLayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #layerTypeAsString}.
     * </p>
     * 
     * @return The layer type.
     * @see GeospatialLayerType
     */
    public final GeospatialLayerType layerType() {
        return GeospatialLayerType.fromValue(layerType);
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layerType} will
     * return {@link GeospatialLayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #layerTypeAsString}.
     * </p>
     * 
     * @return The layer type.
     * @see GeospatialLayerType
     */
    public final String layerTypeAsString() {
        return layerType;
    }

    /**
     * <p>
     * The data source for the layer.
     * </p>
     * 
     * @return The data source for the layer.
     */
    public final GeospatialDataSourceItem dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The label that is displayed for the layer.
     * </p>
     * 
     * @return The label that is displayed for the layer.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * The state of visibility for the layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for the layer.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The state of visibility for the layer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The state of visibility for the layer.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * The definition properties for a layer.
     * </p>
     * 
     * @return The definition properties for a layer.
     */
    public final GeospatialLayerDefinition layerDefinition() {
        return layerDefinition;
    }

    /**
     * Returns the value of the Tooltip property for this object.
     * 
     * @return The value of the Tooltip property for this object.
     */
    public final TooltipOptions tooltip() {
        return tooltip;
    }

    /**
     * <p>
     * The join definition properties for a layer.
     * </p>
     * 
     * @return The join definition properties for a layer.
     */
    public final GeospatialLayerJoinDefinition joinDefinition() {
        return joinDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom actions for a layer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of custom actions for a layer.
     */
    public final List<LayerCustomAction> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(layerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(layerDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(joinDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeospatialLayerItem)) {
            return false;
        }
        GeospatialLayerItem other = (GeospatialLayerItem) obj;
        return Objects.equals(layerId(), other.layerId()) && Objects.equals(layerTypeAsString(), other.layerTypeAsString())
                && Objects.equals(dataSource(), other.dataSource()) && Objects.equals(label(), other.label())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(layerDefinition(), other.layerDefinition()) && Objects.equals(tooltip(), other.tooltip())
                && Objects.equals(joinDefinition(), other.joinDefinition()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeospatialLayerItem").add("LayerId", layerId()).add("LayerType", layerTypeAsString())
                .add("DataSource", dataSource()).add("Label", label()).add("Visibility", visibilityAsString())
                .add("LayerDefinition", layerDefinition()).add("Tooltip", tooltip()).add("JoinDefinition", joinDefinition())
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        case "LayerType":
            return Optional.ofNullable(clazz.cast(layerTypeAsString()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "LayerDefinition":
            return Optional.ofNullable(clazz.cast(layerDefinition()));
        case "Tooltip":
            return Optional.ofNullable(clazz.cast(tooltip()));
        case "JoinDefinition":
            return Optional.ofNullable(clazz.cast(joinDefinition()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LayerId", LAYER_ID_FIELD);
        map.put("LayerType", LAYER_TYPE_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("LayerDefinition", LAYER_DEFINITION_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("JoinDefinition", JOIN_DEFINITION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeospatialLayerItem, T> g) {
        return obj -> g.apply((GeospatialLayerItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GeospatialLayerItem> {
        /**
         * <p>
         * The ID of the layer.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param layerType
         *        The layer type.
         * @see GeospatialLayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialLayerType
         */
        Builder layerType(String layerType);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param layerType
         *        The layer type.
         * @see GeospatialLayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeospatialLayerType
         */
        Builder layerType(GeospatialLayerType layerType);

        /**
         * <p>
         * The data source for the layer.
         * </p>
         * 
         * @param dataSource
         *        The data source for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(GeospatialDataSourceItem dataSource);

        /**
         * <p>
         * The data source for the layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialDataSourceItem.Builder}
         * avoiding the need to create one manually via {@link GeospatialDataSourceItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialDataSourceItem.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSource(GeospatialDataSourceItem)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link GeospatialDataSourceItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(GeospatialDataSourceItem)
         */
        default Builder dataSource(Consumer<GeospatialDataSourceItem.Builder> dataSource) {
            return dataSource(GeospatialDataSourceItem.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The label that is displayed for the layer.
         * </p>
         * 
         * @param label
         *        The label that is displayed for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The state of visibility for the layer.
         * </p>
         * 
         * @param visibility
         *        The state of visibility for the layer.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The state of visibility for the layer.
         * </p>
         * 
         * @param visibility
         *        The state of visibility for the layer.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        /**
         * <p>
         * The definition properties for a layer.
         * </p>
         * 
         * @param layerDefinition
         *        The definition properties for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerDefinition(GeospatialLayerDefinition layerDefinition);

        /**
         * <p>
         * The definition properties for a layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLayerDefinition.Builder}
         * avoiding the need to create one manually via {@link GeospatialLayerDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLayerDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #layerDefinition(GeospatialLayerDefinition)}.
         * 
         * @param layerDefinition
         *        a consumer that will call methods on {@link GeospatialLayerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layerDefinition(GeospatialLayerDefinition)
         */
        default Builder layerDefinition(Consumer<GeospatialLayerDefinition.Builder> layerDefinition) {
            return layerDefinition(GeospatialLayerDefinition.builder().applyMutation(layerDefinition).build());
        }

        /**
         * Sets the value of the Tooltip property for this object.
         *
         * @param tooltip
         *        The new value for the Tooltip property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltip(TooltipOptions tooltip);

        /**
         * Sets the value of the Tooltip property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TooltipOptions.Builder} avoiding the need
         * to create one manually via {@link TooltipOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TooltipOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tooltip(TooltipOptions)}.
         * 
         * @param tooltip
         *        a consumer that will call methods on {@link TooltipOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltip(TooltipOptions)
         */
        default Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return tooltip(TooltipOptions.builder().applyMutation(tooltip).build());
        }

        /**
         * <p>
         * The join definition properties for a layer.
         * </p>
         * 
         * @param joinDefinition
         *        The join definition properties for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder joinDefinition(GeospatialLayerJoinDefinition joinDefinition);

        /**
         * <p>
         * The join definition properties for a layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeospatialLayerJoinDefinition.Builder}
         * avoiding the need to create one manually via {@link GeospatialLayerJoinDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeospatialLayerJoinDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #joinDefinition(GeospatialLayerJoinDefinition)}.
         * 
         * @param joinDefinition
         *        a consumer that will call methods on {@link GeospatialLayerJoinDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #joinDefinition(GeospatialLayerJoinDefinition)
         */
        default Builder joinDefinition(Consumer<GeospatialLayerJoinDefinition.Builder> joinDefinition) {
            return joinDefinition(GeospatialLayerJoinDefinition.builder().applyMutation(joinDefinition).build());
        }

        /**
         * <p>
         * A list of custom actions for a layer.
         * </p>
         * 
         * @param actions
         *        A list of custom actions for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<LayerCustomAction> actions);

        /**
         * <p>
         * A list of custom actions for a layer.
         * </p>
         * 
         * @param actions
         *        A list of custom actions for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(LayerCustomAction... actions);

        /**
         * <p>
         * A list of custom actions for a layer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.LayerCustomAction.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.quicksight.model.LayerCustomAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.LayerCustomAction.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<LayerCustomAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.LayerCustomAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<LayerCustomAction>)
         */
        Builder actions(Consumer<LayerCustomAction.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String layerId;

        private String layerType;

        private GeospatialDataSourceItem dataSource;

        private String label;

        private String visibility;

        private GeospatialLayerDefinition layerDefinition;

        private TooltipOptions tooltip;

        private GeospatialLayerJoinDefinition joinDefinition;

        private List<LayerCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeospatialLayerItem model) {
            layerId(model.layerId);
            layerType(model.layerType);
            dataSource(model.dataSource);
            label(model.label);
            visibility(model.visibility);
            layerDefinition(model.layerDefinition);
            tooltip(model.tooltip);
            joinDefinition(model.joinDefinition);
            actions(model.actions);
        }

        public final String getLayerId() {
            return layerId;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final String getLayerType() {
            return layerType;
        }

        public final void setLayerType(String layerType) {
            this.layerType = layerType;
        }

        @Override
        public final Builder layerType(String layerType) {
            this.layerType = layerType;
            return this;
        }

        @Override
        public final Builder layerType(GeospatialLayerType layerType) {
            this.layerType(layerType == null ? null : layerType.toString());
            return this;
        }

        public final GeospatialDataSourceItem.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(GeospatialDataSourceItem.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(GeospatialDataSourceItem dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final GeospatialLayerDefinition.Builder getLayerDefinition() {
            return layerDefinition != null ? layerDefinition.toBuilder() : null;
        }

        public final void setLayerDefinition(GeospatialLayerDefinition.BuilderImpl layerDefinition) {
            this.layerDefinition = layerDefinition != null ? layerDefinition.build() : null;
        }

        @Override
        public final Builder layerDefinition(GeospatialLayerDefinition layerDefinition) {
            this.layerDefinition = layerDefinition;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return tooltip != null ? tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final GeospatialLayerJoinDefinition.Builder getJoinDefinition() {
            return joinDefinition != null ? joinDefinition.toBuilder() : null;
        }

        public final void setJoinDefinition(GeospatialLayerJoinDefinition.BuilderImpl joinDefinition) {
            this.joinDefinition = joinDefinition != null ? joinDefinition.build() : null;
        }

        @Override
        public final Builder joinDefinition(GeospatialLayerJoinDefinition joinDefinition) {
            this.joinDefinition = joinDefinition;
            return this;
        }

        public final List<LayerCustomAction.Builder> getActions() {
            List<LayerCustomAction.Builder> result = LayerCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<LayerCustomAction.BuilderImpl> actions) {
            this.actions = LayerCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<LayerCustomAction> actions) {
            this.actions = LayerCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(LayerCustomAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<LayerCustomAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> LayerCustomAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GeospatialLayerItem build() {
            return new GeospatialLayerItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
