/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scope configuration for a <code>FilterGroup</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterScopeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterScopeConfiguration.Builder, FilterScopeConfiguration> {
    private static final SdkField<SelectedSheetsFilterScopeConfiguration> SELECTED_SHEETS_FIELD = SdkField
            .<SelectedSheetsFilterScopeConfiguration> builder(MarshallingType.SDK_POJO).memberName("SelectedSheets")
            .getter(getter(FilterScopeConfiguration::selectedSheets)).setter(setter(Builder::selectedSheets))
            .constructor(SelectedSheetsFilterScopeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedSheets").build()).build();

    private static final SdkField<AllSheetsFilterScopeConfiguration> ALL_SHEETS_FIELD = SdkField
            .<AllSheetsFilterScopeConfiguration> builder(MarshallingType.SDK_POJO).memberName("AllSheets")
            .getter(getter(FilterScopeConfiguration::allSheets)).setter(setter(Builder::allSheets))
            .constructor(AllSheetsFilterScopeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllSheets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_SHEETS_FIELD,
            ALL_SHEETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SelectedSheetsFilterScopeConfiguration selectedSheets;

    private final AllSheetsFilterScopeConfiguration allSheets;

    private FilterScopeConfiguration(BuilderImpl builder) {
        this.selectedSheets = builder.selectedSheets;
        this.allSheets = builder.allSheets;
    }

    /**
     * <p>
     * The configuration for applying a filter to specific sheets.
     * </p>
     * 
     * @return The configuration for applying a filter to specific sheets.
     */
    public final SelectedSheetsFilterScopeConfiguration selectedSheets() {
        return selectedSheets;
    }

    /**
     * <p>
     * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value for a
     * <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an Analysis,
     * Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     * </p>
     * 
     * @return The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the
     *         value for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in
     *         an Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
     */
    public final AllSheetsFilterScopeConfiguration allSheets() {
        return allSheets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedSheets());
        hashCode = 31 * hashCode + Objects.hashCode(allSheets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterScopeConfiguration)) {
            return false;
        }
        FilterScopeConfiguration other = (FilterScopeConfiguration) obj;
        return Objects.equals(selectedSheets(), other.selectedSheets()) && Objects.equals(allSheets(), other.allSheets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterScopeConfiguration").add("SelectedSheets", selectedSheets()).add("AllSheets", allSheets())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedSheets":
            return Optional.ofNullable(clazz.cast(selectedSheets()));
        case "AllSheets":
            return Optional.ofNullable(clazz.cast(allSheets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelectedSheets", SELECTED_SHEETS_FIELD);
        map.put("AllSheets", ALL_SHEETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterScopeConfiguration, T> g) {
        return obj -> g.apply((FilterScopeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterScopeConfiguration> {
        /**
         * <p>
         * The configuration for applying a filter to specific sheets.
         * </p>
         * 
         * @param selectedSheets
         *        The configuration for applying a filter to specific sheets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets);

        /**
         * <p>
         * The configuration for applying a filter to specific sheets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SelectedSheetsFilterScopeConfiguration.Builder} avoiding the need to create one manually via
         * {@link SelectedSheetsFilterScopeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectedSheetsFilterScopeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #selectedSheets(SelectedSheetsFilterScopeConfiguration)}.
         * 
         * @param selectedSheets
         *        a consumer that will call methods on {@link SelectedSheetsFilterScopeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedSheets(SelectedSheetsFilterScopeConfiguration)
         */
        default Builder selectedSheets(Consumer<SelectedSheetsFilterScopeConfiguration.Builder> selectedSheets) {
            return selectedSheets(SelectedSheetsFilterScopeConfiguration.builder().applyMutation(selectedSheets).build());
        }

        /**
         * <p>
         * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value
         * for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an
         * Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
         * </p>
         * 
         * @param allSheets
         *        The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the
         *        value for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets
         *        in an Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allSheets(AllSheetsFilterScopeConfiguration allSheets);

        /**
         * <p>
         * The configuration that applies a filter to all sheets. When you choose <code>AllSheets</code> as the value
         * for a <code>FilterScopeConfiguration</code>, this filter is applied to all visuals of all sheets in an
         * Analysis, Dashboard, or Template. The <code>AllSheetsFilterScopeConfiguration</code> is chosen.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AllSheetsFilterScopeConfiguration.Builder} avoiding the need to create one manually via
         * {@link AllSheetsFilterScopeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllSheetsFilterScopeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #allSheets(AllSheetsFilterScopeConfiguration)}.
         * 
         * @param allSheets
         *        a consumer that will call methods on {@link AllSheetsFilterScopeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allSheets(AllSheetsFilterScopeConfiguration)
         */
        default Builder allSheets(Consumer<AllSheetsFilterScopeConfiguration.Builder> allSheets) {
            return allSheets(AllSheetsFilterScopeConfiguration.builder().applyMutation(allSheets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SelectedSheetsFilterScopeConfiguration selectedSheets;

        private AllSheetsFilterScopeConfiguration allSheets;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterScopeConfiguration model) {
            selectedSheets(model.selectedSheets);
            allSheets(model.allSheets);
        }

        public final SelectedSheetsFilterScopeConfiguration.Builder getSelectedSheets() {
            return selectedSheets != null ? selectedSheets.toBuilder() : null;
        }

        public final void setSelectedSheets(SelectedSheetsFilterScopeConfiguration.BuilderImpl selectedSheets) {
            this.selectedSheets = selectedSheets != null ? selectedSheets.build() : null;
        }

        @Override
        public final Builder selectedSheets(SelectedSheetsFilterScopeConfiguration selectedSheets) {
            this.selectedSheets = selectedSheets;
            return this;
        }

        public final AllSheetsFilterScopeConfiguration.Builder getAllSheets() {
            return allSheets != null ? allSheets.toBuilder() : null;
        }

        public final void setAllSheets(AllSheetsFilterScopeConfiguration.BuilderImpl allSheets) {
            this.allSheets = allSheets != null ? allSheets.build() : null;
        }

        @Override
        public final Builder allSheets(AllSheetsFilterScopeConfiguration allSheets) {
            this.allSheets = allSheets;
            return this;
        }

        @Override
        public FilterScopeConfiguration build() {
            return new FilterScopeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
