/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options that determine the default settings for a paginated layout configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultPaginatedLayoutConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultPaginatedLayoutConfiguration.Builder, DefaultPaginatedLayoutConfiguration> {
    private static final SdkField<DefaultSectionBasedLayoutConfiguration> SECTION_BASED_FIELD = SdkField
            .<DefaultSectionBasedLayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("SectionBased")
            .getter(getter(DefaultPaginatedLayoutConfiguration::sectionBased)).setter(setter(Builder::sectionBased))
            .constructor(DefaultSectionBasedLayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SectionBased").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_BASED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DefaultSectionBasedLayoutConfiguration sectionBased;

    private DefaultPaginatedLayoutConfiguration(BuilderImpl builder) {
        this.sectionBased = builder.sectionBased;
    }

    /**
     * <p>
     * The options that determine the default settings for a section-based layout configuration.
     * </p>
     * 
     * @return The options that determine the default settings for a section-based layout configuration.
     */
    public final DefaultSectionBasedLayoutConfiguration sectionBased() {
        return sectionBased;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sectionBased());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultPaginatedLayoutConfiguration)) {
            return false;
        }
        DefaultPaginatedLayoutConfiguration other = (DefaultPaginatedLayoutConfiguration) obj;
        return Objects.equals(sectionBased(), other.sectionBased());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultPaginatedLayoutConfiguration").add("SectionBased", sectionBased()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SectionBased":
            return Optional.ofNullable(clazz.cast(sectionBased()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SectionBased", SECTION_BASED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultPaginatedLayoutConfiguration, T> g) {
        return obj -> g.apply((DefaultPaginatedLayoutConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultPaginatedLayoutConfiguration> {
        /**
         * <p>
         * The options that determine the default settings for a section-based layout configuration.
         * </p>
         * 
         * @param sectionBased
         *        The options that determine the default settings for a section-based layout configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sectionBased(DefaultSectionBasedLayoutConfiguration sectionBased);

        /**
         * <p>
         * The options that determine the default settings for a section-based layout configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultSectionBasedLayoutConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultSectionBasedLayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultSectionBasedLayoutConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sectionBased(DefaultSectionBasedLayoutConfiguration)}.
         * 
         * @param sectionBased
         *        a consumer that will call methods on {@link DefaultSectionBasedLayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sectionBased(DefaultSectionBasedLayoutConfiguration)
         */
        default Builder sectionBased(Consumer<DefaultSectionBasedLayoutConfiguration.Builder> sectionBased) {
            return sectionBased(DefaultSectionBasedLayoutConfiguration.builder().applyMutation(sectionBased).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DefaultSectionBasedLayoutConfiguration sectionBased;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPaginatedLayoutConfiguration model) {
            sectionBased(model.sectionBased);
        }

        public final DefaultSectionBasedLayoutConfiguration.Builder getSectionBased() {
            return sectionBased != null ? sectionBased.toBuilder() : null;
        }

        public final void setSectionBased(DefaultSectionBasedLayoutConfiguration.BuilderImpl sectionBased) {
            this.sectionBased = sectionBased != null ? sectionBased.build() : null;
        }

        @Override
        public final Builder sectionBased(DefaultSectionBasedLayoutConfiguration sectionBased) {
            this.sectionBased = sectionBased;
            return this;
        }

        @Override
        public DefaultPaginatedLayoutConfiguration build() {
            return new DefaultPaginatedLayoutConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
