/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom filter that filters based on a single value. This filter can be partially matched.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomFilterConfiguration.Builder, CustomFilterConfiguration> {
    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchOperator").getter(getter(CustomFilterConfiguration::matchOperatorAsString))
            .setter(setter(Builder::matchOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()).build();

    private static final SdkField<String> CATEGORY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CategoryValue").getter(getter(CustomFilterConfiguration::categoryValue))
            .setter(setter(Builder::categoryValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValue").build()).build();

    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectAllOptions").getter(getter(CustomFilterConfiguration::selectAllOptionsAsString))
            .setter(setter(Builder::selectAllOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()).build();

    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(CustomFilterConfiguration::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NullOption").getter(getter(CustomFilterConfiguration::nullOptionAsString))
            .setter(setter(Builder::nullOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_OPERATOR_FIELD,
            CATEGORY_VALUE_FIELD, SELECT_ALL_OPTIONS_FIELD, PARAMETER_NAME_FIELD, NULL_OPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String matchOperator;

    private final String categoryValue;

    private final String selectAllOptions;

    private final String parameterName;

    private final String nullOption;

    private CustomFilterConfiguration(BuilderImpl builder) {
        this.matchOperator = builder.matchOperator;
        this.categoryValue = builder.categoryValue;
        this.selectAllOptions = builder.selectAllOptions;
        this.parameterName = builder.parameterName;
        this.nullOption = builder.nullOption;
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link CategoryFilterMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see CategoryFilterMatchOperator
     */
    public final CategoryFilterMatchOperator matchOperator() {
        return CategoryFilterMatchOperator.fromValue(matchOperator);
    }

    /**
     * <p>
     * The match operator that is used to determine if a filter should be applied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchOperator}
     * will return {@link CategoryFilterMatchOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #matchOperatorAsString}.
     * </p>
     * 
     * @return The match operator that is used to determine if a filter should be applied.
     * @see CategoryFilterMatchOperator
     */
    public final String matchOperatorAsString() {
        return matchOperator;
    }

    /**
     * <p>
     * The category value for the filter.
     * </p>
     * <p>
     * This field is mutually exclusive to <code>ParameterName</code>.
     * </p>
     * 
     * @return The category value for the filter.</p>
     *         <p>
     *         This field is mutually exclusive to <code>ParameterName</code>.
     */
    public final String categoryValue() {
        return categoryValue;
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link CategoryFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see CategoryFilterSelectAllOptions
     */
    public final CategoryFilterSelectAllOptions selectAllOptions() {
        return CategoryFilterSelectAllOptions.fromValue(selectAllOptions);
    }

    /**
     * <p>
     * Select all of the values. Null is not the assigned value of select all.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FILTER_ALL_VALUES</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectAllOptions}
     * will return {@link CategoryFilterSelectAllOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectAllOptionsAsString}.
     * </p>
     * 
     * @return Select all of the values. Null is not the assigned value of select all.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FILTER_ALL_VALUES</code>
     *         </p>
     *         </li>
     * @see CategoryFilterSelectAllOptions
     */
    public final String selectAllOptionsAsString() {
        return selectAllOptions;
    }

    /**
     * <p>
     * The parameter whose value should be used for the filter value.
     * </p>
     * <p>
     * This field is mutually exclusive to <code>CategoryValue</code>.
     * </p>
     * 
     * @return The parameter whose value should be used for the filter value.</p>
     *         <p>
     *         This field is mutually exclusive to <code>CategoryValue</code>.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(nullOption);
    }

    /**
     * <p>
     * This option determines how null values should be treated when filtering data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VALUES</code>: Include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NULLS_ONLY</code>: Only include null values in filtered results.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nullOption} will
     * return {@link FilterNullOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nullOptionAsString}.
     * </p>
     * 
     * @return This option determines how null values should be treated when filtering data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VALUES</code>: Include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NULLS_ONLY</code>: Only include null values in filtered results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
     *         </p>
     *         </li>
     * @see FilterNullOption
     */
    public final String nullOptionAsString() {
        return nullOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(categoryValue());
        hashCode = 31 * hashCode + Objects.hashCode(selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(nullOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFilterConfiguration)) {
            return false;
        }
        CustomFilterConfiguration other = (CustomFilterConfiguration) obj;
        return Objects.equals(matchOperatorAsString(), other.matchOperatorAsString())
                && Objects.equals(categoryValue(), other.categoryValue())
                && Objects.equals(selectAllOptionsAsString(), other.selectAllOptionsAsString())
                && Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(nullOptionAsString(), other.nullOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFilterConfiguration").add("MatchOperator", matchOperatorAsString())
                .add("CategoryValue", categoryValue()).add("SelectAllOptions", selectAllOptionsAsString())
                .add("ParameterName", parameterName()).add("NullOption", nullOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchOperator":
            return Optional.ofNullable(clazz.cast(matchOperatorAsString()));
        case "CategoryValue":
            return Optional.ofNullable(clazz.cast(categoryValue()));
        case "SelectAllOptions":
            return Optional.ofNullable(clazz.cast(selectAllOptionsAsString()));
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "NullOption":
            return Optional.ofNullable(clazz.cast(nullOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchOperator", MATCH_OPERATOR_FIELD);
        map.put("CategoryValue", CATEGORY_VALUE_FIELD);
        map.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
        map.put("ParameterName", PARAMETER_NAME_FIELD);
        map.put("NullOption", NULL_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFilterConfiguration, T> g) {
        return obj -> g.apply((CustomFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFilterConfiguration> {
        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see CategoryFilterMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterMatchOperator
         */
        Builder matchOperator(String matchOperator);

        /**
         * <p>
         * The match operator that is used to determine if a filter should be applied.
         * </p>
         * 
         * @param matchOperator
         *        The match operator that is used to determine if a filter should be applied.
         * @see CategoryFilterMatchOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterMatchOperator
         */
        Builder matchOperator(CategoryFilterMatchOperator matchOperator);

        /**
         * <p>
         * The category value for the filter.
         * </p>
         * <p>
         * This field is mutually exclusive to <code>ParameterName</code>.
         * </p>
         * 
         * @param categoryValue
         *        The category value for the filter.</p>
         *        <p>
         *        This field is mutually exclusive to <code>ParameterName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoryValue(String categoryValue);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see CategoryFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterSelectAllOptions
         */
        Builder selectAllOptions(String selectAllOptions);

        /**
         * <p>
         * Select all of the values. Null is not the assigned value of select all.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FILTER_ALL_VALUES</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectAllOptions
         *        Select all of the values. Null is not the assigned value of select all.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FILTER_ALL_VALUES</code>
         *        </p>
         *        </li>
         * @see CategoryFilterSelectAllOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CategoryFilterSelectAllOptions
         */
        Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions);

        /**
         * <p>
         * The parameter whose value should be used for the filter value.
         * </p>
         * <p>
         * This field is mutually exclusive to <code>CategoryValue</code>.
         * </p>
         * 
         * @param parameterName
         *        The parameter whose value should be used for the filter value.</p>
         *        <p>
         *        This field is mutually exclusive to <code>CategoryValue</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(String nullOption);

        /**
         * <p>
         * This option determines how null values should be treated when filtering data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VALUES</code>: Include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NULLS_ONLY</code>: Only include null values in filtered results.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nullOption
         *        This option determines how null values should be treated when filtering data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VALUES</code>: Include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NULLS_ONLY</code>: Only include null values in filtered results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NON_NULLS_ONLY</code>: Exclude null values from filtered results.
         *        </p>
         *        </li>
         * @see FilterNullOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FilterNullOption
         */
        Builder nullOption(FilterNullOption nullOption);
    }

    static final class BuilderImpl implements Builder {
        private String matchOperator;

        private String categoryValue;

        private String selectAllOptions;

        private String parameterName;

        private String nullOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFilterConfiguration model) {
            matchOperator(model.matchOperator);
            categoryValue(model.categoryValue);
            selectAllOptions(model.selectAllOptions);
            parameterName(model.parameterName);
            nullOption(model.nullOption);
        }

        public final String getMatchOperator() {
            return matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(CategoryFilterMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final String getCategoryValue() {
            return categoryValue;
        }

        public final void setCategoryValue(String categoryValue) {
            this.categoryValue = categoryValue;
        }

        @Override
        public final Builder categoryValue(String categoryValue) {
            this.categoryValue = categoryValue;
            return this;
        }

        public final String getSelectAllOptions() {
            return selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNullOption() {
            return nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        @Override
        public CustomFilterConfiguration build() {
            return new CustomFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
