/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AxisDisplayOptions;
import software.amazon.awssdk.services.quicksight.model.BarChartFieldWells;
import software.amazon.awssdk.services.quicksight.model.BarChartOrientation;
import software.amazon.awssdk.services.quicksight.model.BarChartSortConfiguration;
import software.amazon.awssdk.services.quicksight.model.BarsArrangement;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefault;
import software.amazon.awssdk.services.quicksight.model.ContributionAnalysisDefaultListCopier;
import software.amazon.awssdk.services.quicksight.model.DataLabelOptions;
import software.amazon.awssdk.services.quicksight.model.LegendOptions;
import software.amazon.awssdk.services.quicksight.model.ReferenceLine;
import software.amazon.awssdk.services.quicksight.model.ReferenceLineListCopier;
import software.amazon.awssdk.services.quicksight.model.SmallMultiplesOptions;
import software.amazon.awssdk.services.quicksight.model.TooltipOptions;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.VisualPalette;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BarChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BarChartConfiguration> {
    private static final SdkField<BarChartFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(BarChartConfiguration.getter(BarChartConfiguration::fieldWells)).setter(BarChartConfiguration.setter(Builder::fieldWells)).constructor(BarChartFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<BarChartSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(BarChartConfiguration.getter(BarChartConfiguration::sortConfiguration)).setter(BarChartConfiguration.setter(Builder::sortConfiguration)).constructor(BarChartSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<String> ORIENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Orientation").getter(BarChartConfiguration.getter(BarChartConfiguration::orientationAsString)).setter(BarChartConfiguration.setter(Builder::orientation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orientation").build()}).build();
    private static final SdkField<String> BARS_ARRANGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BarsArrangement").getter(BarChartConfiguration.getter(BarChartConfiguration::barsArrangementAsString)).setter(BarChartConfiguration.setter(Builder::barsArrangement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BarsArrangement").build()}).build();
    private static final SdkField<VisualPalette> VISUAL_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VisualPalette").getter(BarChartConfiguration.getter(BarChartConfiguration::visualPalette)).setter(BarChartConfiguration.setter(Builder::visualPalette)).constructor(VisualPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualPalette").build()}).build();
    private static final SdkField<SmallMultiplesOptions> SMALL_MULTIPLES_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmallMultiplesOptions").getter(BarChartConfiguration.getter(BarChartConfiguration::smallMultiplesOptions)).setter(BarChartConfiguration.setter(Builder::smallMultiplesOptions)).constructor(SmallMultiplesOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmallMultiplesOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> CATEGORY_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryAxis").getter(BarChartConfiguration.getter(BarChartConfiguration::categoryAxis)).setter(BarChartConfiguration.setter(Builder::categoryAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(BarChartConfiguration.getter(BarChartConfiguration::categoryLabelOptions)).setter(BarChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<AxisDisplayOptions> VALUE_AXIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueAxis").getter(BarChartConfiguration.getter(BarChartConfiguration::valueAxis)).setter(BarChartConfiguration.setter(Builder::valueAxis)).constructor(AxisDisplayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueAxis").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> VALUE_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueLabelOptions").getter(BarChartConfiguration.getter(BarChartConfiguration::valueLabelOptions)).setter(BarChartConfiguration.setter(Builder::valueLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLabelOptions").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> COLOR_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorLabelOptions").getter(BarChartConfiguration.getter(BarChartConfiguration::colorLabelOptions)).setter(BarChartConfiguration.setter(Builder::colorLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorLabelOptions").build()}).build();
    private static final SdkField<LegendOptions> LEGEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Legend").getter(BarChartConfiguration.getter(BarChartConfiguration::legend)).setter(BarChartConfiguration.setter(Builder::legend)).constructor(LegendOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legend").build()}).build();
    private static final SdkField<DataLabelOptions> DATA_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataLabels").getter(BarChartConfiguration.getter(BarChartConfiguration::dataLabels)).setter(BarChartConfiguration.setter(Builder::dataLabels)).constructor(DataLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLabels").build()}).build();
    private static final SdkField<TooltipOptions> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(BarChartConfiguration.getter(BarChartConfiguration::tooltip)).setter(BarChartConfiguration.setter(Builder::tooltip)).constructor(TooltipOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<List<ReferenceLine>> REFERENCE_LINES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceLines").getter(BarChartConfiguration.getter(BarChartConfiguration::referenceLines)).setter(BarChartConfiguration.setter(Builder::referenceLines)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLines").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceLine::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContributionAnalysisDefault>> CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContributionAnalysisDefaults").getter(BarChartConfiguration.getter(BarChartConfiguration::contributionAnalysisDefaults)).setter(BarChartConfiguration.setter(Builder::contributionAnalysisDefaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionAnalysisDefaults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContributionAnalysisDefault::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(BarChartConfiguration.getter(BarChartConfiguration::interactions)).setter(BarChartConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, ORIENTATION_FIELD, BARS_ARRANGEMENT_FIELD, VISUAL_PALETTE_FIELD, SMALL_MULTIPLES_OPTIONS_FIELD, CATEGORY_AXIS_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, VALUE_AXIS_FIELD, VALUE_LABEL_OPTIONS_FIELD, COLOR_LABEL_OPTIONS_FIELD, LEGEND_FIELD, DATA_LABELS_FIELD, TOOLTIP_FIELD, REFERENCE_LINES_FIELD, CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BarChartConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BarChartFieldWells fieldWells;
    private final BarChartSortConfiguration sortConfiguration;
    private final String orientation;
    private final String barsArrangement;
    private final VisualPalette visualPalette;
    private final SmallMultiplesOptions smallMultiplesOptions;
    private final AxisDisplayOptions categoryAxis;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final AxisDisplayOptions valueAxis;
    private final ChartAxisLabelOptions valueLabelOptions;
    private final ChartAxisLabelOptions colorLabelOptions;
    private final LegendOptions legend;
    private final DataLabelOptions dataLabels;
    private final TooltipOptions tooltip;
    private final List<ReferenceLine> referenceLines;
    private final List<ContributionAnalysisDefault> contributionAnalysisDefaults;
    private final VisualInteractionOptions interactions;

    private BarChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.orientation = builder.orientation;
        this.barsArrangement = builder.barsArrangement;
        this.visualPalette = builder.visualPalette;
        this.smallMultiplesOptions = builder.smallMultiplesOptions;
        this.categoryAxis = builder.categoryAxis;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.valueAxis = builder.valueAxis;
        this.valueLabelOptions = builder.valueLabelOptions;
        this.colorLabelOptions = builder.colorLabelOptions;
        this.legend = builder.legend;
        this.dataLabels = builder.dataLabels;
        this.tooltip = builder.tooltip;
        this.referenceLines = builder.referenceLines;
        this.contributionAnalysisDefaults = builder.contributionAnalysisDefaults;
        this.interactions = builder.interactions;
    }

    public final BarChartFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final BarChartSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final BarChartOrientation orientation() {
        return BarChartOrientation.fromValue(this.orientation);
    }

    public final String orientationAsString() {
        return this.orientation;
    }

    public final BarsArrangement barsArrangement() {
        return BarsArrangement.fromValue(this.barsArrangement);
    }

    public final String barsArrangementAsString() {
        return this.barsArrangement;
    }

    public final VisualPalette visualPalette() {
        return this.visualPalette;
    }

    public final SmallMultiplesOptions smallMultiplesOptions() {
        return this.smallMultiplesOptions;
    }

    public final AxisDisplayOptions categoryAxis() {
        return this.categoryAxis;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final AxisDisplayOptions valueAxis() {
        return this.valueAxis;
    }

    public final ChartAxisLabelOptions valueLabelOptions() {
        return this.valueLabelOptions;
    }

    public final ChartAxisLabelOptions colorLabelOptions() {
        return this.colorLabelOptions;
    }

    public final LegendOptions legend() {
        return this.legend;
    }

    public final DataLabelOptions dataLabels() {
        return this.dataLabels;
    }

    public final TooltipOptions tooltip() {
        return this.tooltip;
    }

    public final boolean hasReferenceLines() {
        return this.referenceLines != null && !(this.referenceLines instanceof SdkAutoConstructList);
    }

    public final List<ReferenceLine> referenceLines() {
        return this.referenceLines;
    }

    public final boolean hasContributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults != null && !(this.contributionAnalysisDefaults instanceof SdkAutoConstructList);
    }

    public final List<ContributionAnalysisDefault> contributionAnalysisDefaults() {
        return this.contributionAnalysisDefaults;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.orientationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.barsArrangementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallMultiplesOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueAxis());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.legend());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceLines() ? this.referenceLines() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BarChartConfiguration)) {
            return false;
        }
        BarChartConfiguration other = (BarChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.orientationAsString(), other.orientationAsString()) && Objects.equals(this.barsArrangementAsString(), other.barsArrangementAsString()) && Objects.equals(this.visualPalette(), other.visualPalette()) && Objects.equals(this.smallMultiplesOptions(), other.smallMultiplesOptions()) && Objects.equals(this.categoryAxis(), other.categoryAxis()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.valueAxis(), other.valueAxis()) && Objects.equals(this.valueLabelOptions(), other.valueLabelOptions()) && Objects.equals(this.colorLabelOptions(), other.colorLabelOptions()) && Objects.equals(this.legend(), other.legend()) && Objects.equals(this.dataLabels(), other.dataLabels()) && Objects.equals(this.tooltip(), other.tooltip()) && this.hasReferenceLines() == other.hasReferenceLines() && Objects.equals(this.referenceLines(), other.referenceLines()) && this.hasContributionAnalysisDefaults() == other.hasContributionAnalysisDefaults() && Objects.equals(this.contributionAnalysisDefaults(), other.contributionAnalysisDefaults()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"BarChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("Orientation", (Object)this.orientationAsString()).add("BarsArrangement", (Object)this.barsArrangementAsString()).add("VisualPalette", (Object)this.visualPalette()).add("SmallMultiplesOptions", (Object)this.smallMultiplesOptions()).add("CategoryAxis", (Object)this.categoryAxis()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("ValueAxis", (Object)this.valueAxis()).add("ValueLabelOptions", (Object)this.valueLabelOptions()).add("ColorLabelOptions", (Object)this.colorLabelOptions()).add("Legend", (Object)this.legend()).add("DataLabels", (Object)this.dataLabels()).add("Tooltip", (Object)this.tooltip()).add("ReferenceLines", this.hasReferenceLines() ? this.referenceLines() : null).add("ContributionAnalysisDefaults", this.hasContributionAnalysisDefaults() ? this.contributionAnalysisDefaults() : null).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "Orientation": {
                return Optional.ofNullable(clazz.cast(this.orientationAsString()));
            }
            case "BarsArrangement": {
                return Optional.ofNullable(clazz.cast(this.barsArrangementAsString()));
            }
            case "VisualPalette": {
                return Optional.ofNullable(clazz.cast(this.visualPalette()));
            }
            case "SmallMultiplesOptions": {
                return Optional.ofNullable(clazz.cast(this.smallMultiplesOptions()));
            }
            case "CategoryAxis": {
                return Optional.ofNullable(clazz.cast(this.categoryAxis()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "ValueAxis": {
                return Optional.ofNullable(clazz.cast(this.valueAxis()));
            }
            case "ValueLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.valueLabelOptions()));
            }
            case "ColorLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.colorLabelOptions()));
            }
            case "Legend": {
                return Optional.ofNullable(clazz.cast(this.legend()));
            }
            case "DataLabels": {
                return Optional.ofNullable(clazz.cast(this.dataLabels()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "ReferenceLines": {
                return Optional.ofNullable(clazz.cast(this.referenceLines()));
            }
            case "ContributionAnalysisDefaults": {
                return Optional.ofNullable(clazz.cast(this.contributionAnalysisDefaults()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldWells", FIELD_WELLS_FIELD);
        map.put("SortConfiguration", SORT_CONFIGURATION_FIELD);
        map.put("Orientation", ORIENTATION_FIELD);
        map.put("BarsArrangement", BARS_ARRANGEMENT_FIELD);
        map.put("VisualPalette", VISUAL_PALETTE_FIELD);
        map.put("SmallMultiplesOptions", SMALL_MULTIPLES_OPTIONS_FIELD);
        map.put("CategoryAxis", CATEGORY_AXIS_FIELD);
        map.put("CategoryLabelOptions", CATEGORY_LABEL_OPTIONS_FIELD);
        map.put("ValueAxis", VALUE_AXIS_FIELD);
        map.put("ValueLabelOptions", VALUE_LABEL_OPTIONS_FIELD);
        map.put("ColorLabelOptions", COLOR_LABEL_OPTIONS_FIELD);
        map.put("Legend", LEGEND_FIELD);
        map.put("DataLabels", DATA_LABELS_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ReferenceLines", REFERENCE_LINES_FIELD);
        map.put("ContributionAnalysisDefaults", CONTRIBUTION_ANALYSIS_DEFAULTS_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BarChartConfiguration, T> g) {
        return obj -> g.apply((BarChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BarChartFieldWells fieldWells;
        private BarChartSortConfiguration sortConfiguration;
        private String orientation;
        private String barsArrangement;
        private VisualPalette visualPalette;
        private SmallMultiplesOptions smallMultiplesOptions;
        private AxisDisplayOptions categoryAxis;
        private ChartAxisLabelOptions categoryLabelOptions;
        private AxisDisplayOptions valueAxis;
        private ChartAxisLabelOptions valueLabelOptions;
        private ChartAxisLabelOptions colorLabelOptions;
        private LegendOptions legend;
        private DataLabelOptions dataLabels;
        private TooltipOptions tooltip;
        private List<ReferenceLine> referenceLines = DefaultSdkAutoConstructList.getInstance();
        private List<ContributionAnalysisDefault> contributionAnalysisDefaults = DefaultSdkAutoConstructList.getInstance();
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(BarChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.orientation(model.orientation);
            this.barsArrangement(model.barsArrangement);
            this.visualPalette(model.visualPalette);
            this.smallMultiplesOptions(model.smallMultiplesOptions);
            this.categoryAxis(model.categoryAxis);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.valueAxis(model.valueAxis);
            this.valueLabelOptions(model.valueLabelOptions);
            this.colorLabelOptions(model.colorLabelOptions);
            this.legend(model.legend);
            this.dataLabels(model.dataLabels);
            this.tooltip(model.tooltip);
            this.referenceLines(model.referenceLines);
            this.contributionAnalysisDefaults(model.contributionAnalysisDefaults);
            this.interactions(model.interactions);
        }

        public final BarChartFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(BarChartFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(BarChartFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final BarChartSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(BarChartSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(BarChartSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final String getOrientation() {
            return this.orientation;
        }

        public final void setOrientation(String orientation) {
            this.orientation = orientation;
        }

        @Override
        public final Builder orientation(String orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public final Builder orientation(BarChartOrientation orientation) {
            this.orientation(orientation == null ? null : orientation.toString());
            return this;
        }

        public final String getBarsArrangement() {
            return this.barsArrangement;
        }

        public final void setBarsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
        }

        @Override
        public final Builder barsArrangement(String barsArrangement) {
            this.barsArrangement = barsArrangement;
            return this;
        }

        @Override
        public final Builder barsArrangement(BarsArrangement barsArrangement) {
            this.barsArrangement(barsArrangement == null ? null : barsArrangement.toString());
            return this;
        }

        public final VisualPalette.Builder getVisualPalette() {
            return this.visualPalette != null ? this.visualPalette.toBuilder() : null;
        }

        public final void setVisualPalette(VisualPalette.BuilderImpl visualPalette) {
            this.visualPalette = visualPalette != null ? visualPalette.build() : null;
        }

        @Override
        public final Builder visualPalette(VisualPalette visualPalette) {
            this.visualPalette = visualPalette;
            return this;
        }

        public final SmallMultiplesOptions.Builder getSmallMultiplesOptions() {
            return this.smallMultiplesOptions != null ? this.smallMultiplesOptions.toBuilder() : null;
        }

        public final void setSmallMultiplesOptions(SmallMultiplesOptions.BuilderImpl smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions != null ? smallMultiplesOptions.build() : null;
        }

        @Override
        public final Builder smallMultiplesOptions(SmallMultiplesOptions smallMultiplesOptions) {
            this.smallMultiplesOptions = smallMultiplesOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getCategoryAxis() {
            return this.categoryAxis != null ? this.categoryAxis.toBuilder() : null;
        }

        public final void setCategoryAxis(AxisDisplayOptions.BuilderImpl categoryAxis) {
            this.categoryAxis = categoryAxis != null ? categoryAxis.build() : null;
        }

        @Override
        public final Builder categoryAxis(AxisDisplayOptions categoryAxis) {
            this.categoryAxis = categoryAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final AxisDisplayOptions.Builder getValueAxis() {
            return this.valueAxis != null ? this.valueAxis.toBuilder() : null;
        }

        public final void setValueAxis(AxisDisplayOptions.BuilderImpl valueAxis) {
            this.valueAxis = valueAxis != null ? valueAxis.build() : null;
        }

        @Override
        public final Builder valueAxis(AxisDisplayOptions valueAxis) {
            this.valueAxis = valueAxis;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getValueLabelOptions() {
            return this.valueLabelOptions != null ? this.valueLabelOptions.toBuilder() : null;
        }

        public final void setValueLabelOptions(ChartAxisLabelOptions.BuilderImpl valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions != null ? valueLabelOptions.build() : null;
        }

        @Override
        public final Builder valueLabelOptions(ChartAxisLabelOptions valueLabelOptions) {
            this.valueLabelOptions = valueLabelOptions;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getColorLabelOptions() {
            return this.colorLabelOptions != null ? this.colorLabelOptions.toBuilder() : null;
        }

        public final void setColorLabelOptions(ChartAxisLabelOptions.BuilderImpl colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions != null ? colorLabelOptions.build() : null;
        }

        @Override
        public final Builder colorLabelOptions(ChartAxisLabelOptions colorLabelOptions) {
            this.colorLabelOptions = colorLabelOptions;
            return this;
        }

        public final LegendOptions.Builder getLegend() {
            return this.legend != null ? this.legend.toBuilder() : null;
        }

        public final void setLegend(LegendOptions.BuilderImpl legend) {
            this.legend = legend != null ? legend.build() : null;
        }

        @Override
        public final Builder legend(LegendOptions legend) {
            this.legend = legend;
            return this;
        }

        public final DataLabelOptions.Builder getDataLabels() {
            return this.dataLabels != null ? this.dataLabels.toBuilder() : null;
        }

        public final void setDataLabels(DataLabelOptions.BuilderImpl dataLabels) {
            this.dataLabels = dataLabels != null ? dataLabels.build() : null;
        }

        @Override
        public final Builder dataLabels(DataLabelOptions dataLabels) {
            this.dataLabels = dataLabels;
            return this;
        }

        public final TooltipOptions.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(TooltipOptions.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(TooltipOptions tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final List<ReferenceLine.Builder> getReferenceLines() {
            List<ReferenceLine.Builder> result = ReferenceLineListCopier.copyToBuilder(this.referenceLines);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLines(Collection<ReferenceLine.BuilderImpl> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copyFromBuilder(referenceLines);
        }

        @Override
        public final Builder referenceLines(Collection<ReferenceLine> referenceLines) {
            this.referenceLines = ReferenceLineListCopier.copy(referenceLines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(ReferenceLine ... referenceLines) {
            this.referenceLines(Arrays.asList(referenceLines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLines(Consumer<ReferenceLine.Builder> ... referenceLines) {
            this.referenceLines(Stream.of(referenceLines).map(c -> (ReferenceLine)((ReferenceLine.Builder)ReferenceLine.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContributionAnalysisDefault.Builder> getContributionAnalysisDefaults() {
            List<ContributionAnalysisDefault.Builder> result = ContributionAnalysisDefaultListCopier.copyToBuilder(this.contributionAnalysisDefaults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContributionAnalysisDefaults(Collection<ContributionAnalysisDefault.BuilderImpl> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copyFromBuilder(contributionAnalysisDefaults);
        }

        @Override
        public final Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults = ContributionAnalysisDefaultListCopier.copy(contributionAnalysisDefaults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Arrays.asList(contributionAnalysisDefaults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... contributionAnalysisDefaults) {
            this.contributionAnalysisDefaults(Stream.of(contributionAnalysisDefaults).map(c -> (ContributionAnalysisDefault)((ContributionAnalysisDefault.Builder)ContributionAnalysisDefault.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public BarChartConfiguration build() {
            return new BarChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BarChartConfiguration> {
        public Builder fieldWells(BarChartFieldWells var1);

        default public Builder fieldWells(Consumer<BarChartFieldWells.Builder> fieldWells) {
            return this.fieldWells((BarChartFieldWells)((BarChartFieldWells.Builder)BarChartFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(BarChartSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<BarChartSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((BarChartSortConfiguration)((BarChartSortConfiguration.Builder)BarChartSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder orientation(String var1);

        public Builder orientation(BarChartOrientation var1);

        public Builder barsArrangement(String var1);

        public Builder barsArrangement(BarsArrangement var1);

        public Builder visualPalette(VisualPalette var1);

        default public Builder visualPalette(Consumer<VisualPalette.Builder> visualPalette) {
            return this.visualPalette((VisualPalette)((VisualPalette.Builder)VisualPalette.builder().applyMutation(visualPalette)).build());
        }

        public Builder smallMultiplesOptions(SmallMultiplesOptions var1);

        default public Builder smallMultiplesOptions(Consumer<SmallMultiplesOptions.Builder> smallMultiplesOptions) {
            return this.smallMultiplesOptions((SmallMultiplesOptions)((SmallMultiplesOptions.Builder)SmallMultiplesOptions.builder().applyMutation(smallMultiplesOptions)).build());
        }

        public Builder categoryAxis(AxisDisplayOptions var1);

        default public Builder categoryAxis(Consumer<AxisDisplayOptions.Builder> categoryAxis) {
            return this.categoryAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(categoryAxis)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder valueAxis(AxisDisplayOptions var1);

        default public Builder valueAxis(Consumer<AxisDisplayOptions.Builder> valueAxis) {
            return this.valueAxis((AxisDisplayOptions)((AxisDisplayOptions.Builder)AxisDisplayOptions.builder().applyMutation(valueAxis)).build());
        }

        public Builder valueLabelOptions(ChartAxisLabelOptions var1);

        default public Builder valueLabelOptions(Consumer<ChartAxisLabelOptions.Builder> valueLabelOptions) {
            return this.valueLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(valueLabelOptions)).build());
        }

        public Builder colorLabelOptions(ChartAxisLabelOptions var1);

        default public Builder colorLabelOptions(Consumer<ChartAxisLabelOptions.Builder> colorLabelOptions) {
            return this.colorLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(colorLabelOptions)).build());
        }

        public Builder legend(LegendOptions var1);

        default public Builder legend(Consumer<LegendOptions.Builder> legend) {
            return this.legend((LegendOptions)((LegendOptions.Builder)LegendOptions.builder().applyMutation(legend)).build());
        }

        public Builder dataLabels(DataLabelOptions var1);

        default public Builder dataLabels(Consumer<DataLabelOptions.Builder> dataLabels) {
            return this.dataLabels((DataLabelOptions)((DataLabelOptions.Builder)DataLabelOptions.builder().applyMutation(dataLabels)).build());
        }

        public Builder tooltip(TooltipOptions var1);

        default public Builder tooltip(Consumer<TooltipOptions.Builder> tooltip) {
            return this.tooltip((TooltipOptions)((TooltipOptions.Builder)TooltipOptions.builder().applyMutation(tooltip)).build());
        }

        public Builder referenceLines(Collection<ReferenceLine> var1);

        public Builder referenceLines(ReferenceLine ... var1);

        public Builder referenceLines(Consumer<ReferenceLine.Builder> ... var1);

        public Builder contributionAnalysisDefaults(Collection<ContributionAnalysisDefault> var1);

        public Builder contributionAnalysisDefaults(ContributionAnalysisDefault ... var1);

        public Builder contributionAnalysisDefaults(Consumer<ContributionAnalysisDefault.Builder> ... var1);

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

