/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisErrorType;
import software.amazon.awssdk.services.quicksight.model.Entity;
import software.amazon.awssdk.services.quicksight.model.EntityListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisError> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AnalysisError.getter(AnalysisError::typeAsString)).setter(AnalysisError.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(AnalysisError.getter(AnalysisError::message)).setter(AnalysisError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<List<Entity>> VIOLATED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViolatedEntities").getter(AnalysisError.getter(AnalysisError::violatedEntities)).setter(AnalysisError.setter(Builder::violatedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatedEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD, VIOLATED_ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String message;
    private final List<Entity> violatedEntities;

    private AnalysisError(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.violatedEntities = builder.violatedEntities;
    }

    public final AnalysisErrorType type() {
        return AnalysisErrorType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasViolatedEntities() {
        return this.violatedEntities != null && !(this.violatedEntities instanceof SdkAutoConstructList);
    }

    public final List<Entity> violatedEntities() {
        return this.violatedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViolatedEntities() ? this.violatedEntities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisError)) {
            return false;
        }
        AnalysisError other = (AnalysisError)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message()) && this.hasViolatedEntities() == other.hasViolatedEntities() && Objects.equals(this.violatedEntities(), other.violatedEntities());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisError").add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).add("ViolatedEntities", this.hasViolatedEntities() ? this.violatedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ViolatedEntities": {
                return Optional.ofNullable(clazz.cast(this.violatedEntities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("ViolatedEntities", VIOLATED_ENTITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisError, T> g) {
        return obj -> g.apply((AnalysisError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;
        private List<Entity> violatedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisError model) {
            this.type(model.type);
            this.message(model.message);
            this.violatedEntities(model.violatedEntities);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AnalysisErrorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Entity.Builder> getViolatedEntities() {
            List<Entity.Builder> result = EntityListCopier.copyToBuilder(this.violatedEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatedEntities(Collection<Entity.BuilderImpl> violatedEntities) {
            this.violatedEntities = EntityListCopier.copyFromBuilder(violatedEntities);
        }

        @Override
        public final Builder violatedEntities(Collection<Entity> violatedEntities) {
            this.violatedEntities = EntityListCopier.copy(violatedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatedEntities(Entity ... violatedEntities) {
            this.violatedEntities(Arrays.asList(violatedEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatedEntities(Consumer<Entity.Builder> ... violatedEntities) {
            this.violatedEntities(Stream.of(violatedEntities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalysisError build() {
            return new AnalysisError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisError> {
        public Builder type(String var1);

        public Builder type(AnalysisErrorType var1);

        public Builder message(String var1);

        public Builder violatedEntities(Collection<Entity> var1);

        public Builder violatedEntities(Entity ... var1);

        public Builder violatedEntities(Consumer<Entity.Builder> ... var1);
    }
}

