/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.User;

public class ListUsersIterable
implements SdkIterable<ListUsersResponse> {
    private final QuickSightClient client;
    private final ListUsersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUsersIterable(QuickSightClient client, ListUsersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public Iterator<ListUsersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<User> userList() {
        Function<ListUsersResponse, Iterator> getIterator = response -> {
            if (response != null && response.userList() != null) {
                return response.userList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUsersResponseFetcher
    implements SyncPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUsersResponse nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersIterable.this.client.listUsers(ListUsersIterable.this.firstRequest);
            }
            return ListUsersIterable.this.client.listUsers((ListUsersRequest)((Object)ListUsersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

