/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.InnerFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NestedFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NestedFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(NestedFilter.getter(NestedFilter::filterId)).setter(NestedFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(NestedFilter.getter(NestedFilter::column)).setter(NestedFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Boolean> INCLUDE_INNER_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeInnerSet").getter(NestedFilter.getter(NestedFilter::includeInnerSet)).setter(NestedFilter.setter(Builder::includeInnerSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeInnerSet").build()}).build();
    private static final SdkField<InnerFilter> INNER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InnerFilter").getter(NestedFilter.getter(NestedFilter::innerFilter)).setter(NestedFilter.setter(Builder::innerFilter)).constructor(InnerFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InnerFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, INCLUDE_INNER_SET_FIELD, INNER_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NestedFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final Boolean includeInnerSet;
    private final InnerFilter innerFilter;

    private NestedFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeInnerSet = builder.includeInnerSet;
        this.innerFilter = builder.innerFilter;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Boolean includeInnerSet() {
        return this.includeInnerSet;
    }

    public final InnerFilter innerFilter() {
        return this.innerFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeInnerSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.innerFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NestedFilter)) {
            return false;
        }
        NestedFilter other = (NestedFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.includeInnerSet(), other.includeInnerSet()) && Objects.equals(this.innerFilter(), other.innerFilter());
    }

    public final String toString() {
        return ToString.builder((String)"NestedFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("IncludeInnerSet", (Object)this.includeInnerSet()).add("InnerFilter", (Object)this.innerFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "IncludeInnerSet": {
                return Optional.ofNullable(clazz.cast(this.includeInnerSet()));
            }
            case "InnerFilter": {
                return Optional.ofNullable(clazz.cast(this.innerFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FilterId", FILTER_ID_FIELD);
        map.put("Column", COLUMN_FIELD);
        map.put("IncludeInnerSet", INCLUDE_INNER_SET_FIELD);
        map.put("InnerFilter", INNER_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NestedFilter, T> g) {
        return obj -> g.apply((NestedFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private Boolean includeInnerSet;
        private InnerFilter innerFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(NestedFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.includeInnerSet(model.includeInnerSet);
            this.innerFilter(model.innerFilter);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeInnerSet() {
            return this.includeInnerSet;
        }

        public final void setIncludeInnerSet(Boolean includeInnerSet) {
            this.includeInnerSet = includeInnerSet;
        }

        @Override
        public final Builder includeInnerSet(Boolean includeInnerSet) {
            this.includeInnerSet = includeInnerSet;
            return this;
        }

        public final InnerFilter.Builder getInnerFilter() {
            return this.innerFilter != null ? this.innerFilter.toBuilder() : null;
        }

        public final void setInnerFilter(InnerFilter.BuilderImpl innerFilter) {
            this.innerFilter = innerFilter != null ? innerFilter.build() : null;
        }

        @Override
        public final Builder innerFilter(InnerFilter innerFilter) {
            this.innerFilter = innerFilter;
            return this;
        }

        public NestedFilter build() {
            return new NestedFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NestedFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder includeInnerSet(Boolean var1);

        public Builder innerFilter(InnerFilter var1);

        default public Builder innerFilter(Consumer<InnerFilter.Builder> innerFilter) {
            return this.innerFilter((InnerFilter)((InnerFilter.Builder)InnerFilter.builder().applyMutation(innerFilter)).build());
        }
    }
}

