/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourcePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobDataSourceOverridePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobDataSourceOverridePermissions> {
    private static final SdkField<List<String>> DATA_SOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSourceIds").getter(AssetBundleImportJobDataSourceOverridePermissions.getter(AssetBundleImportJobDataSourceOverridePermissions::dataSourceIds)).setter(AssetBundleImportJobDataSourceOverridePermissions.setter(Builder::dataSourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(AssetBundleImportJobDataSourceOverridePermissions.getter(AssetBundleImportJobDataSourceOverridePermissions::permissions)).setter(AssetBundleImportJobDataSourceOverridePermissions.setter(Builder::permissions)).constructor(AssetBundleResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_IDS_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetBundleImportJobDataSourceOverridePermissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> dataSourceIds;
    private final AssetBundleResourcePermissions permissions;

    private AssetBundleImportJobDataSourceOverridePermissions(BuilderImpl builder) {
        this.dataSourceIds = builder.dataSourceIds;
        this.permissions = builder.permissions;
    }

    public final boolean hasDataSourceIds() {
        return this.dataSourceIds != null && !(this.dataSourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> dataSourceIds() {
        return this.dataSourceIds;
    }

    public final AssetBundleResourcePermissions permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSourceIds() ? this.dataSourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobDataSourceOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobDataSourceOverridePermissions other = (AssetBundleImportJobDataSourceOverridePermissions)obj;
        return this.hasDataSourceIds() == other.hasDataSourceIds() && Objects.equals(this.dataSourceIds(), other.dataSourceIds()) && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobDataSourceOverridePermissions").add("DataSourceIds", this.hasDataSourceIds() ? this.dataSourceIds() : null).add("Permissions", (Object)this.permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceIds": {
                return Optional.ofNullable(clazz.cast(this.dataSourceIds()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSourceIds", DATA_SOURCE_IDS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobDataSourceOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobDataSourceOverridePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dataSourceIds = DefaultSdkAutoConstructList.getInstance();
        private AssetBundleResourcePermissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobDataSourceOverridePermissions model) {
            this.dataSourceIds(model.dataSourceIds);
            this.permissions(model.permissions);
        }

        public final Collection<String> getDataSourceIds() {
            if (this.dataSourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSourceIds;
        }

        public final void setDataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = AssetBundleRestrictiveResourceIdListCopier.copy(dataSourceIds);
        }

        @Override
        public final Builder dataSourceIds(Collection<String> dataSourceIds) {
            this.dataSourceIds = AssetBundleRestrictiveResourceIdListCopier.copy(dataSourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourceIds(String ... dataSourceIds) {
            this.dataSourceIds(Arrays.asList(dataSourceIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssetBundleImportJobDataSourceOverridePermissions build() {
            return new AssetBundleImportJobDataSourceOverridePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobDataSourceOverridePermissions> {
        public Builder dataSourceIds(Collection<String> var1);

        public Builder dataSourceIds(String ... var1);

        public Builder permissions(AssetBundleResourcePermissions var1);

        default public Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return this.permissions((AssetBundleResourcePermissions)((AssetBundleResourcePermissions.Builder)AssetBundleResourcePermissions.builder().applyMutation(permissions)).build());
        }
    }
}

