/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListVpcConnectionsResponse;

public class ListVPCConnectionsIterable
implements SdkIterable<ListVpcConnectionsResponse> {
    private final QuickSightClient client;
    private final ListVpcConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVPCConnectionsIterable(QuickSightClient client, ListVpcConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVpcConnectionsResponseFetcher();
    }

    public Iterator<ListVpcConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVpcConnectionsResponseFetcher
    implements SyncPageFetcher<ListVpcConnectionsResponse> {
        private ListVpcConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcConnectionsResponse nextPage(ListVpcConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListVPCConnectionsIterable.this.client.listVPCConnections(ListVPCConnectionsIterable.this.firstRequest);
            }
            return ListVPCConnectionsIterable.this.client.listVPCConnections((ListVpcConnectionsRequest)((Object)ListVPCConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

