/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NumberScale {
    NONE("NONE"),
    AUTO("AUTO"),
    THOUSANDS("THOUSANDS"),
    MILLIONS("MILLIONS"),
    BILLIONS("BILLIONS"),
    TRILLIONS("TRILLIONS"),
    LAKHS("LAKHS"),
    CRORES("CRORES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NumberScale> VALUE_MAP;
    private final String value;

    private NumberScale(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumberScale fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumberScale> knownValues() {
        EnumSet<NumberScale> knownValues = EnumSet.allOf(NumberScale.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NumberScale.class, NumberScale::toString);
    }
}

