/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.KPIActualValueConditionalFormatting;
import software.amazon.awssdk.services.quicksight.model.KPIComparisonValueConditionalFormatting;
import software.amazon.awssdk.services.quicksight.model.KPIPrimaryValueConditionalFormatting;
import software.amazon.awssdk.services.quicksight.model.KPIProgressBarConditionalFormatting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KPIConditionalFormattingOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KPIConditionalFormattingOption> {
    private static final SdkField<KPIPrimaryValueConditionalFormatting> PRIMARY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrimaryValue").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::primaryValue)).setter(KPIConditionalFormattingOption.setter(Builder::primaryValue)).constructor(KPIPrimaryValueConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValue").build()}).build();
    private static final SdkField<KPIProgressBarConditionalFormatting> PROGRESS_BAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressBar").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::progressBar)).setter(KPIConditionalFormattingOption.setter(Builder::progressBar)).constructor(KPIProgressBarConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressBar").build()}).build();
    private static final SdkField<KPIActualValueConditionalFormatting> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActualValue").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::actualValue)).setter(KPIConditionalFormattingOption.setter(Builder::actualValue)).constructor(KPIActualValueConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()}).build();
    private static final SdkField<KPIComparisonValueConditionalFormatting> COMPARISON_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComparisonValue").getter(KPIConditionalFormattingOption.getter(KPIConditionalFormattingOption::comparisonValue)).setter(KPIConditionalFormattingOption.setter(Builder::comparisonValue)).constructor(KPIComparisonValueConditionalFormatting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_VALUE_FIELD, PROGRESS_BAR_FIELD, ACTUAL_VALUE_FIELD, COMPARISON_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KPIConditionalFormattingOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KPIPrimaryValueConditionalFormatting primaryValue;
    private final KPIProgressBarConditionalFormatting progressBar;
    private final KPIActualValueConditionalFormatting actualValue;
    private final KPIComparisonValueConditionalFormatting comparisonValue;

    private KPIConditionalFormattingOption(BuilderImpl builder) {
        this.primaryValue = builder.primaryValue;
        this.progressBar = builder.progressBar;
        this.actualValue = builder.actualValue;
        this.comparisonValue = builder.comparisonValue;
    }

    public final KPIPrimaryValueConditionalFormatting primaryValue() {
        return this.primaryValue;
    }

    public final KPIProgressBarConditionalFormatting progressBar() {
        return this.progressBar;
    }

    public final KPIActualValueConditionalFormatting actualValue() {
        return this.actualValue;
    }

    public final KPIComparisonValueConditionalFormatting comparisonValue() {
        return this.comparisonValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressBar());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KPIConditionalFormattingOption)) {
            return false;
        }
        KPIConditionalFormattingOption other = (KPIConditionalFormattingOption)obj;
        return Objects.equals(this.primaryValue(), other.primaryValue()) && Objects.equals(this.progressBar(), other.progressBar()) && Objects.equals(this.actualValue(), other.actualValue()) && Objects.equals(this.comparisonValue(), other.comparisonValue());
    }

    public final String toString() {
        return ToString.builder((String)"KPIConditionalFormattingOption").add("PrimaryValue", (Object)this.primaryValue()).add("ProgressBar", (Object)this.progressBar()).add("ActualValue", (Object)this.actualValue()).add("ComparisonValue", (Object)this.comparisonValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryValue": {
                return Optional.ofNullable(clazz.cast(this.primaryValue()));
            }
            case "ProgressBar": {
                return Optional.ofNullable(clazz.cast(this.progressBar()));
            }
            case "ActualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValue()));
            }
            case "ComparisonValue": {
                return Optional.ofNullable(clazz.cast(this.comparisonValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PrimaryValue", PRIMARY_VALUE_FIELD);
        map.put("ProgressBar", PROGRESS_BAR_FIELD);
        map.put("ActualValue", ACTUAL_VALUE_FIELD);
        map.put("ComparisonValue", COMPARISON_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KPIConditionalFormattingOption, T> g) {
        return obj -> g.apply((KPIConditionalFormattingOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KPIPrimaryValueConditionalFormatting primaryValue;
        private KPIProgressBarConditionalFormatting progressBar;
        private KPIActualValueConditionalFormatting actualValue;
        private KPIComparisonValueConditionalFormatting comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(KPIConditionalFormattingOption model) {
            this.primaryValue(model.primaryValue);
            this.progressBar(model.progressBar);
            this.actualValue(model.actualValue);
            this.comparisonValue(model.comparisonValue);
        }

        public final KPIPrimaryValueConditionalFormatting.Builder getPrimaryValue() {
            return this.primaryValue != null ? this.primaryValue.toBuilder() : null;
        }

        public final void setPrimaryValue(KPIPrimaryValueConditionalFormatting.BuilderImpl primaryValue) {
            this.primaryValue = primaryValue != null ? primaryValue.build() : null;
        }

        @Override
        public final Builder primaryValue(KPIPrimaryValueConditionalFormatting primaryValue) {
            this.primaryValue = primaryValue;
            return this;
        }

        public final KPIProgressBarConditionalFormatting.Builder getProgressBar() {
            return this.progressBar != null ? this.progressBar.toBuilder() : null;
        }

        public final void setProgressBar(KPIProgressBarConditionalFormatting.BuilderImpl progressBar) {
            this.progressBar = progressBar != null ? progressBar.build() : null;
        }

        @Override
        public final Builder progressBar(KPIProgressBarConditionalFormatting progressBar) {
            this.progressBar = progressBar;
            return this;
        }

        public final KPIActualValueConditionalFormatting.Builder getActualValue() {
            return this.actualValue != null ? this.actualValue.toBuilder() : null;
        }

        public final void setActualValue(KPIActualValueConditionalFormatting.BuilderImpl actualValue) {
            this.actualValue = actualValue != null ? actualValue.build() : null;
        }

        @Override
        public final Builder actualValue(KPIActualValueConditionalFormatting actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final KPIComparisonValueConditionalFormatting.Builder getComparisonValue() {
            return this.comparisonValue != null ? this.comparisonValue.toBuilder() : null;
        }

        public final void setComparisonValue(KPIComparisonValueConditionalFormatting.BuilderImpl comparisonValue) {
            this.comparisonValue = comparisonValue != null ? comparisonValue.build() : null;
        }

        @Override
        public final Builder comparisonValue(KPIComparisonValueConditionalFormatting comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        public KPIConditionalFormattingOption build() {
            return new KPIConditionalFormattingOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KPIConditionalFormattingOption> {
        public Builder primaryValue(KPIPrimaryValueConditionalFormatting var1);

        default public Builder primaryValue(Consumer<KPIPrimaryValueConditionalFormatting.Builder> primaryValue) {
            return this.primaryValue((KPIPrimaryValueConditionalFormatting)((KPIPrimaryValueConditionalFormatting.Builder)KPIPrimaryValueConditionalFormatting.builder().applyMutation(primaryValue)).build());
        }

        public Builder progressBar(KPIProgressBarConditionalFormatting var1);

        default public Builder progressBar(Consumer<KPIProgressBarConditionalFormatting.Builder> progressBar) {
            return this.progressBar((KPIProgressBarConditionalFormatting)((KPIProgressBarConditionalFormatting.Builder)KPIProgressBarConditionalFormatting.builder().applyMutation(progressBar)).build());
        }

        public Builder actualValue(KPIActualValueConditionalFormatting var1);

        default public Builder actualValue(Consumer<KPIActualValueConditionalFormatting.Builder> actualValue) {
            return this.actualValue((KPIActualValueConditionalFormatting)((KPIActualValueConditionalFormatting.Builder)KPIActualValueConditionalFormatting.builder().applyMutation(actualValue)).build());
        }

        public Builder comparisonValue(KPIComparisonValueConditionalFormatting var1);

        default public Builder comparisonValue(Consumer<KPIComparisonValueConditionalFormatting.Builder> comparisonValue) {
            return this.comparisonValue((KPIComparisonValueConditionalFormatting)((KPIComparisonValueConditionalFormatting.Builder)KPIComparisonValueConditionalFormatting.builder().applyMutation(comparisonValue)).build());
        }
    }
}

