/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterMatchOperator;
import software.amazon.awssdk.services.quicksight.model.CategoryFilterSelectAllOptions;
import software.amazon.awssdk.services.quicksight.model.CategoryValueListCopier;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomFilterListConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomFilterListConfiguration> {
    private static final SdkField<String> MATCH_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchOperator").getter(CustomFilterListConfiguration.getter(CustomFilterListConfiguration::matchOperatorAsString)).setter(CustomFilterListConfiguration.setter(Builder::matchOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOperator").build()}).build();
    private static final SdkField<List<String>> CATEGORY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategoryValues").getter(CustomFilterListConfiguration.getter(CustomFilterListConfiguration::categoryValues)).setter(CustomFilterListConfiguration.setter(Builder::categoryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECT_ALL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectAllOptions").getter(CustomFilterListConfiguration.getter(CustomFilterListConfiguration::selectAllOptionsAsString)).setter(CustomFilterListConfiguration.setter(Builder::selectAllOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectAllOptions").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(CustomFilterListConfiguration.getter(CustomFilterListConfiguration::nullOptionAsString)).setter(CustomFilterListConfiguration.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_OPERATOR_FIELD, CATEGORY_VALUES_FIELD, SELECT_ALL_OPTIONS_FIELD, NULL_OPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomFilterListConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String matchOperator;
    private final List<String> categoryValues;
    private final String selectAllOptions;
    private final String nullOption;

    private CustomFilterListConfiguration(BuilderImpl builder) {
        this.matchOperator = builder.matchOperator;
        this.categoryValues = builder.categoryValues;
        this.selectAllOptions = builder.selectAllOptions;
        this.nullOption = builder.nullOption;
    }

    public final CategoryFilterMatchOperator matchOperator() {
        return CategoryFilterMatchOperator.fromValue(this.matchOperator);
    }

    public final String matchOperatorAsString() {
        return this.matchOperator;
    }

    public final boolean hasCategoryValues() {
        return this.categoryValues != null && !(this.categoryValues instanceof SdkAutoConstructList);
    }

    public final List<String> categoryValues() {
        return this.categoryValues;
    }

    public final CategoryFilterSelectAllOptions selectAllOptions() {
        return CategoryFilterSelectAllOptions.fromValue(this.selectAllOptions);
    }

    public final String selectAllOptionsAsString() {
        return this.selectAllOptions;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategoryValues() ? this.categoryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAllOptionsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFilterListConfiguration)) {
            return false;
        }
        CustomFilterListConfiguration other = (CustomFilterListConfiguration)obj;
        return Objects.equals(this.matchOperatorAsString(), other.matchOperatorAsString()) && this.hasCategoryValues() == other.hasCategoryValues() && Objects.equals(this.categoryValues(), other.categoryValues()) && Objects.equals(this.selectAllOptionsAsString(), other.selectAllOptionsAsString()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomFilterListConfiguration").add("MatchOperator", (Object)this.matchOperatorAsString()).add("CategoryValues", this.hasCategoryValues() ? this.categoryValues() : null).add("SelectAllOptions", (Object)this.selectAllOptionsAsString()).add("NullOption", (Object)this.nullOptionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchOperator": {
                return Optional.ofNullable(clazz.cast(this.matchOperatorAsString()));
            }
            case "CategoryValues": {
                return Optional.ofNullable(clazz.cast(this.categoryValues()));
            }
            case "SelectAllOptions": {
                return Optional.ofNullable(clazz.cast(this.selectAllOptionsAsString()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchOperator", MATCH_OPERATOR_FIELD);
        map.put("CategoryValues", CATEGORY_VALUES_FIELD);
        map.put("SelectAllOptions", SELECT_ALL_OPTIONS_FIELD);
        map.put("NullOption", NULL_OPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFilterListConfiguration, T> g) {
        return obj -> g.apply((CustomFilterListConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String matchOperator;
        private List<String> categoryValues = DefaultSdkAutoConstructList.getInstance();
        private String selectAllOptions;
        private String nullOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFilterListConfiguration model) {
            this.matchOperator(model.matchOperator);
            this.categoryValues(model.categoryValues);
            this.selectAllOptions(model.selectAllOptions);
            this.nullOption(model.nullOption);
        }

        public final String getMatchOperator() {
            return this.matchOperator;
        }

        public final void setMatchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
        }

        @Override
        public final Builder matchOperator(String matchOperator) {
            this.matchOperator = matchOperator;
            return this;
        }

        @Override
        public final Builder matchOperator(CategoryFilterMatchOperator matchOperator) {
            this.matchOperator(matchOperator == null ? null : matchOperator.toString());
            return this;
        }

        public final Collection<String> getCategoryValues() {
            if (this.categoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categoryValues;
        }

        public final void setCategoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
        }

        @Override
        public final Builder categoryValues(Collection<String> categoryValues) {
            this.categoryValues = CategoryValueListCopier.copy(categoryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categoryValues(String ... categoryValues) {
            this.categoryValues(Arrays.asList(categoryValues));
            return this;
        }

        public final String getSelectAllOptions() {
            return this.selectAllOptions;
        }

        public final void setSelectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
        }

        @Override
        public final Builder selectAllOptions(String selectAllOptions) {
            this.selectAllOptions = selectAllOptions;
            return this;
        }

        @Override
        public final Builder selectAllOptions(CategoryFilterSelectAllOptions selectAllOptions) {
            this.selectAllOptions(selectAllOptions == null ? null : selectAllOptions.toString());
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public CustomFilterListConfiguration build() {
            return new CustomFilterListConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomFilterListConfiguration> {
        public Builder matchOperator(String var1);

        public Builder matchOperator(CategoryFilterMatchOperator var1);

        public Builder categoryValues(Collection<String> var1);

        public Builder categoryValues(String ... var1);

        public Builder selectAllOptions(String var1);

        public Builder selectAllOptions(CategoryFilterSelectAllOptions var1);

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);
    }
}

