/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ImageCustomAction;
import software.amazon.awssdk.services.quicksight.model.ImageCustomActionListCopier;
import software.amazon.awssdk.services.quicksight.model.ImageInteractionOptions;
import software.amazon.awssdk.services.quicksight.model.SheetImageScalingConfiguration;
import software.amazon.awssdk.services.quicksight.model.SheetImageSource;
import software.amazon.awssdk.services.quicksight.model.SheetImageTooltipConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetImage> {
    private static final SdkField<String> SHEET_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SheetImageId").getter(SheetImage.getter(SheetImage::sheetImageId)).setter(SheetImage.setter(Builder::sheetImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetImageId").build()}).build();
    private static final SdkField<SheetImageSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(SheetImage.getter(SheetImage::source)).setter(SheetImage.setter(Builder::source)).constructor(SheetImageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<SheetImageScalingConfiguration> SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scaling").getter(SheetImage.getter(SheetImage::scaling)).setter(SheetImage.setter(Builder::scaling)).constructor(SheetImageScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scaling").build()}).build();
    private static final SdkField<SheetImageTooltipConfiguration> TOOLTIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tooltip").getter(SheetImage.getter(SheetImage::tooltip)).setter(SheetImage.setter(Builder::tooltip)).constructor(SheetImageTooltipConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tooltip").build()}).build();
    private static final SdkField<String> IMAGE_CONTENT_ALT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageContentAltText").getter(SheetImage.getter(SheetImage::imageContentAltText)).setter(SheetImage.setter(Builder::imageContentAltText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageContentAltText").build()}).build();
    private static final SdkField<ImageInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(SheetImage.getter(SheetImage::interactions)).setter(SheetImage.setter(Builder::interactions)).constructor(ImageInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final SdkField<List<ImageCustomAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(SheetImage.getter(SheetImage::actions)).setter(SheetImage.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageCustomAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_IMAGE_ID_FIELD, SOURCE_FIELD, SCALING_FIELD, TOOLTIP_FIELD, IMAGE_CONTENT_ALT_TEXT_FIELD, INTERACTIONS_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SheetImage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sheetImageId;
    private final SheetImageSource source;
    private final SheetImageScalingConfiguration scaling;
    private final SheetImageTooltipConfiguration tooltip;
    private final String imageContentAltText;
    private final ImageInteractionOptions interactions;
    private final List<ImageCustomAction> actions;

    private SheetImage(BuilderImpl builder) {
        this.sheetImageId = builder.sheetImageId;
        this.source = builder.source;
        this.scaling = builder.scaling;
        this.tooltip = builder.tooltip;
        this.imageContentAltText = builder.imageContentAltText;
        this.interactions = builder.interactions;
        this.actions = builder.actions;
    }

    public final String sheetImageId() {
        return this.sheetImageId;
    }

    public final SheetImageSource source() {
        return this.source;
    }

    public final SheetImageScalingConfiguration scaling() {
        return this.scaling;
    }

    public final SheetImageTooltipConfiguration tooltip() {
        return this.tooltip;
    }

    public final String imageContentAltText() {
        return this.imageContentAltText;
    }

    public final ImageInteractionOptions interactions() {
        return this.interactions;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<ImageCustomAction> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaling());
        hashCode = 31 * hashCode + Objects.hashCode(this.tooltip());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageContentAltText());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImage)) {
            return false;
        }
        SheetImage other = (SheetImage)obj;
        return Objects.equals(this.sheetImageId(), other.sheetImageId()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.scaling(), other.scaling()) && Objects.equals(this.tooltip(), other.tooltip()) && Objects.equals(this.imageContentAltText(), other.imageContentAltText()) && Objects.equals(this.interactions(), other.interactions()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"SheetImage").add("SheetImageId", (Object)this.sheetImageId()).add("Source", (Object)this.source()).add("Scaling", (Object)this.scaling()).add("Tooltip", (Object)this.tooltip()).add("ImageContentAltText", (Object)this.imageContentAltText()).add("Interactions", (Object)this.interactions()).add("Actions", this.hasActions() ? this.actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SheetImageId": {
                return Optional.ofNullable(clazz.cast(this.sheetImageId()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Scaling": {
                return Optional.ofNullable(clazz.cast(this.scaling()));
            }
            case "Tooltip": {
                return Optional.ofNullable(clazz.cast(this.tooltip()));
            }
            case "ImageContentAltText": {
                return Optional.ofNullable(clazz.cast(this.imageContentAltText()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SheetImageId", SHEET_IMAGE_ID_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Scaling", SCALING_FIELD);
        map.put("Tooltip", TOOLTIP_FIELD);
        map.put("ImageContentAltText", IMAGE_CONTENT_ALT_TEXT_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImage, T> g) {
        return obj -> g.apply((SheetImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sheetImageId;
        private SheetImageSource source;
        private SheetImageScalingConfiguration scaling;
        private SheetImageTooltipConfiguration tooltip;
        private String imageContentAltText;
        private ImageInteractionOptions interactions;
        private List<ImageCustomAction> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImage model) {
            this.sheetImageId(model.sheetImageId);
            this.source(model.source);
            this.scaling(model.scaling);
            this.tooltip(model.tooltip);
            this.imageContentAltText(model.imageContentAltText);
            this.interactions(model.interactions);
            this.actions(model.actions);
        }

        public final String getSheetImageId() {
            return this.sheetImageId;
        }

        public final void setSheetImageId(String sheetImageId) {
            this.sheetImageId = sheetImageId;
        }

        @Override
        public final Builder sheetImageId(String sheetImageId) {
            this.sheetImageId = sheetImageId;
            return this;
        }

        public final SheetImageSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(SheetImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(SheetImageSource source) {
            this.source = source;
            return this;
        }

        public final SheetImageScalingConfiguration.Builder getScaling() {
            return this.scaling != null ? this.scaling.toBuilder() : null;
        }

        public final void setScaling(SheetImageScalingConfiguration.BuilderImpl scaling) {
            this.scaling = scaling != null ? scaling.build() : null;
        }

        @Override
        public final Builder scaling(SheetImageScalingConfiguration scaling) {
            this.scaling = scaling;
            return this;
        }

        public final SheetImageTooltipConfiguration.Builder getTooltip() {
            return this.tooltip != null ? this.tooltip.toBuilder() : null;
        }

        public final void setTooltip(SheetImageTooltipConfiguration.BuilderImpl tooltip) {
            this.tooltip = tooltip != null ? tooltip.build() : null;
        }

        @Override
        public final Builder tooltip(SheetImageTooltipConfiguration tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public final String getImageContentAltText() {
            return this.imageContentAltText;
        }

        public final void setImageContentAltText(String imageContentAltText) {
            this.imageContentAltText = imageContentAltText;
        }

        @Override
        public final Builder imageContentAltText(String imageContentAltText) {
            this.imageContentAltText = imageContentAltText;
            return this;
        }

        public final ImageInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(ImageInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(ImageInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public final List<ImageCustomAction.Builder> getActions() {
            List<ImageCustomAction.Builder> result = ImageCustomActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ImageCustomAction.BuilderImpl> actions) {
            this.actions = ImageCustomActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ImageCustomAction> actions) {
            this.actions = ImageCustomActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ImageCustomAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ImageCustomAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ImageCustomAction)((ImageCustomAction.Builder)ImageCustomAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SheetImage build() {
            return new SheetImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetImage> {
        public Builder sheetImageId(String var1);

        public Builder source(SheetImageSource var1);

        default public Builder source(Consumer<SheetImageSource.Builder> source) {
            return this.source((SheetImageSource)((SheetImageSource.Builder)SheetImageSource.builder().applyMutation(source)).build());
        }

        public Builder scaling(SheetImageScalingConfiguration var1);

        default public Builder scaling(Consumer<SheetImageScalingConfiguration.Builder> scaling) {
            return this.scaling((SheetImageScalingConfiguration)((SheetImageScalingConfiguration.Builder)SheetImageScalingConfiguration.builder().applyMutation(scaling)).build());
        }

        public Builder tooltip(SheetImageTooltipConfiguration var1);

        default public Builder tooltip(Consumer<SheetImageTooltipConfiguration.Builder> tooltip) {
            return this.tooltip((SheetImageTooltipConfiguration)((SheetImageTooltipConfiguration.Builder)SheetImageTooltipConfiguration.builder().applyMutation(tooltip)).build());
        }

        public Builder imageContentAltText(String var1);

        public Builder interactions(ImageInteractionOptions var1);

        default public Builder interactions(Consumer<ImageInteractionOptions.Builder> interactions) {
            return this.interactions((ImageInteractionOptions)((ImageInteractionOptions.Builder)ImageInteractionOptions.builder().applyMutation(interactions)).build());
        }

        public Builder actions(Collection<ImageCustomAction> var1);

        public Builder actions(ImageCustomAction ... var1);

        public Builder actions(Consumer<ImageCustomAction.Builder> ... var1);
    }
}

