/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PluginVisualConfiguration;
import software.amazon.awssdk.services.quicksight.model.VisualSubtitleLabelOptions;
import software.amazon.awssdk.services.quicksight.model.VisualTitleLabelOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginVisual
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginVisual> {
    private static final SdkField<String> VISUAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualId").getter(PluginVisual.getter(PluginVisual::visualId)).setter(PluginVisual.setter(Builder::visualId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualId").build()}).build();
    private static final SdkField<String> PLUGIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginArn").getter(PluginVisual.getter(PluginVisual::pluginArn)).setter(PluginVisual.setter(Builder::pluginArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginArn").build()}).build();
    private static final SdkField<VisualTitleLabelOptions> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Title").getter(PluginVisual.getter(PluginVisual::title)).setter(PluginVisual.setter(Builder::title)).constructor(VisualTitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<VisualSubtitleLabelOptions> SUBTITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Subtitle").getter(PluginVisual.getter(PluginVisual::subtitle)).setter(PluginVisual.setter(Builder::subtitle)).constructor(VisualSubtitleLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtitle").build()}).build();
    private static final SdkField<PluginVisualConfiguration> CHART_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChartConfiguration").getter(PluginVisual.getter(PluginVisual::chartConfiguration)).setter(PluginVisual.setter(Builder::chartConfiguration)).constructor(PluginVisualConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChartConfiguration").build()}).build();
    private static final SdkField<String> VISUAL_CONTENT_ALT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VisualContentAltText").getter(PluginVisual.getter(PluginVisual::visualContentAltText)).setter(PluginVisual.setter(Builder::visualContentAltText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualContentAltText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VISUAL_ID_FIELD, PLUGIN_ARN_FIELD, TITLE_FIELD, SUBTITLE_FIELD, CHART_CONFIGURATION_FIELD, VISUAL_CONTENT_ALT_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PluginVisual.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String visualId;
    private final String pluginArn;
    private final VisualTitleLabelOptions title;
    private final VisualSubtitleLabelOptions subtitle;
    private final PluginVisualConfiguration chartConfiguration;
    private final String visualContentAltText;

    private PluginVisual(BuilderImpl builder) {
        this.visualId = builder.visualId;
        this.pluginArn = builder.pluginArn;
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.chartConfiguration = builder.chartConfiguration;
        this.visualContentAltText = builder.visualContentAltText;
    }

    public final String visualId() {
        return this.visualId;
    }

    public final String pluginArn() {
        return this.pluginArn;
    }

    public final VisualTitleLabelOptions title() {
        return this.title;
    }

    public final VisualSubtitleLabelOptions subtitle() {
        return this.subtitle;
    }

    public final PluginVisualConfiguration chartConfiguration() {
        return this.chartConfiguration;
    }

    public final String visualContentAltText() {
        return this.visualContentAltText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.visualId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.subtitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.chartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.visualContentAltText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginVisual)) {
            return false;
        }
        PluginVisual other = (PluginVisual)obj;
        return Objects.equals(this.visualId(), other.visualId()) && Objects.equals(this.pluginArn(), other.pluginArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.subtitle(), other.subtitle()) && Objects.equals(this.chartConfiguration(), other.chartConfiguration()) && Objects.equals(this.visualContentAltText(), other.visualContentAltText());
    }

    public final String toString() {
        return ToString.builder((String)"PluginVisual").add("VisualId", (Object)this.visualId()).add("PluginArn", (Object)this.pluginArn()).add("Title", (Object)this.title()).add("Subtitle", (Object)this.subtitle()).add("ChartConfiguration", (Object)this.chartConfiguration()).add("VisualContentAltText", (Object)this.visualContentAltText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VisualId": {
                return Optional.ofNullable(clazz.cast(this.visualId()));
            }
            case "PluginArn": {
                return Optional.ofNullable(clazz.cast(this.pluginArn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Subtitle": {
                return Optional.ofNullable(clazz.cast(this.subtitle()));
            }
            case "ChartConfiguration": {
                return Optional.ofNullable(clazz.cast(this.chartConfiguration()));
            }
            case "VisualContentAltText": {
                return Optional.ofNullable(clazz.cast(this.visualContentAltText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VisualId", VISUAL_ID_FIELD);
        map.put("PluginArn", PLUGIN_ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Subtitle", SUBTITLE_FIELD);
        map.put("ChartConfiguration", CHART_CONFIGURATION_FIELD);
        map.put("VisualContentAltText", VISUAL_CONTENT_ALT_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginVisual, T> g) {
        return obj -> g.apply((PluginVisual)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String visualId;
        private String pluginArn;
        private VisualTitleLabelOptions title;
        private VisualSubtitleLabelOptions subtitle;
        private PluginVisualConfiguration chartConfiguration;
        private String visualContentAltText;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginVisual model) {
            this.visualId(model.visualId);
            this.pluginArn(model.pluginArn);
            this.title(model.title);
            this.subtitle(model.subtitle);
            this.chartConfiguration(model.chartConfiguration);
            this.visualContentAltText(model.visualContentAltText);
        }

        public final String getVisualId() {
            return this.visualId;
        }

        public final void setVisualId(String visualId) {
            this.visualId = visualId;
        }

        @Override
        public final Builder visualId(String visualId) {
            this.visualId = visualId;
            return this;
        }

        public final String getPluginArn() {
            return this.pluginArn;
        }

        public final void setPluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
        }

        @Override
        public final Builder pluginArn(String pluginArn) {
            this.pluginArn = pluginArn;
            return this;
        }

        public final VisualTitleLabelOptions.Builder getTitle() {
            return this.title != null ? this.title.toBuilder() : null;
        }

        public final void setTitle(VisualTitleLabelOptions.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(VisualTitleLabelOptions title) {
            this.title = title;
            return this;
        }

        public final VisualSubtitleLabelOptions.Builder getSubtitle() {
            return this.subtitle != null ? this.subtitle.toBuilder() : null;
        }

        public final void setSubtitle(VisualSubtitleLabelOptions.BuilderImpl subtitle) {
            this.subtitle = subtitle != null ? subtitle.build() : null;
        }

        @Override
        public final Builder subtitle(VisualSubtitleLabelOptions subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public final PluginVisualConfiguration.Builder getChartConfiguration() {
            return this.chartConfiguration != null ? this.chartConfiguration.toBuilder() : null;
        }

        public final void setChartConfiguration(PluginVisualConfiguration.BuilderImpl chartConfiguration) {
            this.chartConfiguration = chartConfiguration != null ? chartConfiguration.build() : null;
        }

        @Override
        public final Builder chartConfiguration(PluginVisualConfiguration chartConfiguration) {
            this.chartConfiguration = chartConfiguration;
            return this;
        }

        public final String getVisualContentAltText() {
            return this.visualContentAltText;
        }

        public final void setVisualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
        }

        @Override
        public final Builder visualContentAltText(String visualContentAltText) {
            this.visualContentAltText = visualContentAltText;
            return this;
        }

        public PluginVisual build() {
            return new PluginVisual(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginVisual> {
        public Builder visualId(String var1);

        public Builder pluginArn(String var1);

        public Builder title(VisualTitleLabelOptions var1);

        default public Builder title(Consumer<VisualTitleLabelOptions.Builder> title) {
            return this.title((VisualTitleLabelOptions)((VisualTitleLabelOptions.Builder)VisualTitleLabelOptions.builder().applyMutation(title)).build());
        }

        public Builder subtitle(VisualSubtitleLabelOptions var1);

        default public Builder subtitle(Consumer<VisualSubtitleLabelOptions.Builder> subtitle) {
            return this.subtitle((VisualSubtitleLabelOptions)((VisualSubtitleLabelOptions.Builder)VisualSubtitleLabelOptions.builder().applyMutation(subtitle)).build());
        }

        public Builder chartConfiguration(PluginVisualConfiguration var1);

        default public Builder chartConfiguration(Consumer<PluginVisualConfiguration.Builder> chartConfiguration) {
            return this.chartConfiguration((PluginVisualConfiguration)((PluginVisualConfiguration.Builder)PluginVisualConfiguration.builder().applyMutation(chartConfiguration)).build());
        }

        public Builder visualContentAltText(String var1);
    }
}

