/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.BodySectionRepeatDimensionConfiguration;
import software.amazon.awssdk.services.quicksight.model.BodySectionRepeatDimensionConfigurationListCopier;
import software.amazon.awssdk.services.quicksight.model.BodySectionRepeatPageBreakConfiguration;
import software.amazon.awssdk.services.quicksight.model.NonRepeatingVisualsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BodySectionRepeatConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BodySectionRepeatConfiguration> {
    private static final SdkField<List<BodySectionRepeatDimensionConfiguration>> DIMENSION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionConfigurations").getter(BodySectionRepeatConfiguration.getter(BodySectionRepeatConfiguration::dimensionConfigurations)).setter(BodySectionRepeatConfiguration.setter(Builder::dimensionConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BodySectionRepeatDimensionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BodySectionRepeatPageBreakConfiguration> PAGE_BREAK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PageBreakConfiguration").getter(BodySectionRepeatConfiguration.getter(BodySectionRepeatConfiguration::pageBreakConfiguration)).setter(BodySectionRepeatConfiguration.setter(Builder::pageBreakConfiguration)).constructor(BodySectionRepeatPageBreakConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageBreakConfiguration").build()}).build();
    private static final SdkField<List<String>> NON_REPEATING_VISUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonRepeatingVisuals").getter(BodySectionRepeatConfiguration.getter(BodySectionRepeatConfiguration::nonRepeatingVisuals)).setter(BodySectionRepeatConfiguration.setter(Builder::nonRepeatingVisuals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonRepeatingVisuals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_CONFIGURATIONS_FIELD, PAGE_BREAK_CONFIGURATION_FIELD, NON_REPEATING_VISUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BodySectionRepeatConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BodySectionRepeatDimensionConfiguration> dimensionConfigurations;
    private final BodySectionRepeatPageBreakConfiguration pageBreakConfiguration;
    private final List<String> nonRepeatingVisuals;

    private BodySectionRepeatConfiguration(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
        this.pageBreakConfiguration = builder.pageBreakConfiguration;
        this.nonRepeatingVisuals = builder.nonRepeatingVisuals;
    }

    public final boolean hasDimensionConfigurations() {
        return this.dimensionConfigurations != null && !(this.dimensionConfigurations instanceof SdkAutoConstructList);
    }

    public final List<BodySectionRepeatDimensionConfiguration> dimensionConfigurations() {
        return this.dimensionConfigurations;
    }

    public final BodySectionRepeatPageBreakConfiguration pageBreakConfiguration() {
        return this.pageBreakConfiguration;
    }

    public final boolean hasNonRepeatingVisuals() {
        return this.nonRepeatingVisuals != null && !(this.nonRepeatingVisuals instanceof SdkAutoConstructList);
    }

    public final List<String> nonRepeatingVisuals() {
        return this.nonRepeatingVisuals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionConfigurations() ? this.dimensionConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pageBreakConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonRepeatingVisuals() ? this.nonRepeatingVisuals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BodySectionRepeatConfiguration)) {
            return false;
        }
        BodySectionRepeatConfiguration other = (BodySectionRepeatConfiguration)obj;
        return this.hasDimensionConfigurations() == other.hasDimensionConfigurations() && Objects.equals(this.dimensionConfigurations(), other.dimensionConfigurations()) && Objects.equals(this.pageBreakConfiguration(), other.pageBreakConfiguration()) && this.hasNonRepeatingVisuals() == other.hasNonRepeatingVisuals() && Objects.equals(this.nonRepeatingVisuals(), other.nonRepeatingVisuals());
    }

    public final String toString() {
        return ToString.builder((String)"BodySectionRepeatConfiguration").add("DimensionConfigurations", this.hasDimensionConfigurations() ? this.dimensionConfigurations() : null).add("PageBreakConfiguration", (Object)this.pageBreakConfiguration()).add("NonRepeatingVisuals", this.hasNonRepeatingVisuals() ? this.nonRepeatingVisuals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dimensionConfigurations()));
            }
            case "PageBreakConfiguration": {
                return Optional.ofNullable(clazz.cast(this.pageBreakConfiguration()));
            }
            case "NonRepeatingVisuals": {
                return Optional.ofNullable(clazz.cast(this.nonRepeatingVisuals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DimensionConfigurations", DIMENSION_CONFIGURATIONS_FIELD);
        map.put("PageBreakConfiguration", PAGE_BREAK_CONFIGURATION_FIELD);
        map.put("NonRepeatingVisuals", NON_REPEATING_VISUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BodySectionRepeatConfiguration, T> g) {
        return obj -> g.apply((BodySectionRepeatConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BodySectionRepeatDimensionConfiguration> dimensionConfigurations = DefaultSdkAutoConstructList.getInstance();
        private BodySectionRepeatPageBreakConfiguration pageBreakConfiguration;
        private List<String> nonRepeatingVisuals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BodySectionRepeatConfiguration model) {
            this.dimensionConfigurations(model.dimensionConfigurations);
            this.pageBreakConfiguration(model.pageBreakConfiguration);
            this.nonRepeatingVisuals(model.nonRepeatingVisuals);
        }

        public final List<BodySectionRepeatDimensionConfiguration.Builder> getDimensionConfigurations() {
            List<BodySectionRepeatDimensionConfiguration.Builder> result = BodySectionRepeatDimensionConfigurationListCopier.copyToBuilder(this.dimensionConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionConfigurations(Collection<BodySectionRepeatDimensionConfiguration.BuilderImpl> dimensionConfigurations) {
            this.dimensionConfigurations = BodySectionRepeatDimensionConfigurationListCopier.copyFromBuilder(dimensionConfigurations);
        }

        @Override
        public final Builder dimensionConfigurations(Collection<BodySectionRepeatDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = BodySectionRepeatDimensionConfigurationListCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(BodySectionRepeatDimensionConfiguration ... dimensionConfigurations) {
            this.dimensionConfigurations(Arrays.asList(dimensionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(Consumer<BodySectionRepeatDimensionConfiguration.Builder> ... dimensionConfigurations) {
            this.dimensionConfigurations(Stream.of(dimensionConfigurations).map(c -> (BodySectionRepeatDimensionConfiguration)((BodySectionRepeatDimensionConfiguration.Builder)BodySectionRepeatDimensionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BodySectionRepeatPageBreakConfiguration.Builder getPageBreakConfiguration() {
            return this.pageBreakConfiguration != null ? this.pageBreakConfiguration.toBuilder() : null;
        }

        public final void setPageBreakConfiguration(BodySectionRepeatPageBreakConfiguration.BuilderImpl pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration != null ? pageBreakConfiguration.build() : null;
        }

        @Override
        public final Builder pageBreakConfiguration(BodySectionRepeatPageBreakConfiguration pageBreakConfiguration) {
            this.pageBreakConfiguration = pageBreakConfiguration;
            return this;
        }

        public final Collection<String> getNonRepeatingVisuals() {
            if (this.nonRepeatingVisuals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonRepeatingVisuals;
        }

        public final void setNonRepeatingVisuals(Collection<String> nonRepeatingVisuals) {
            this.nonRepeatingVisuals = NonRepeatingVisualsListCopier.copy(nonRepeatingVisuals);
        }

        @Override
        public final Builder nonRepeatingVisuals(Collection<String> nonRepeatingVisuals) {
            this.nonRepeatingVisuals = NonRepeatingVisualsListCopier.copy(nonRepeatingVisuals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonRepeatingVisuals(String ... nonRepeatingVisuals) {
            this.nonRepeatingVisuals(Arrays.asList(nonRepeatingVisuals));
            return this;
        }

        public BodySectionRepeatConfiguration build() {
            return new BodySectionRepeatConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BodySectionRepeatConfiguration> {
        public Builder dimensionConfigurations(Collection<BodySectionRepeatDimensionConfiguration> var1);

        public Builder dimensionConfigurations(BodySectionRepeatDimensionConfiguration ... var1);

        public Builder dimensionConfigurations(Consumer<BodySectionRepeatDimensionConfiguration.Builder> ... var1);

        public Builder pageBreakConfiguration(BodySectionRepeatPageBreakConfiguration var1);

        default public Builder pageBreakConfiguration(Consumer<BodySectionRepeatPageBreakConfiguration.Builder> pageBreakConfiguration) {
            return this.pageBreakConfiguration((BodySectionRepeatPageBreakConfiguration)((BodySectionRepeatPageBreakConfiguration.Builder)BodySectionRepeatPageBreakConfiguration.builder().applyMutation(pageBreakConfiguration)).build());
        }

        public Builder nonRepeatingVisuals(Collection<String> var1);

        public Builder nonRepeatingVisuals(String ... var1);
    }
}

