/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ImageStaticFile;
import software.amazon.awssdk.services.quicksight.model.SpatialStaticFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StaticFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StaticFile> {
    private static final SdkField<ImageStaticFile> IMAGE_STATIC_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageStaticFile").getter(StaticFile.getter(StaticFile::imageStaticFile)).setter(StaticFile.setter(Builder::imageStaticFile)).constructor(ImageStaticFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageStaticFile").build()}).build();
    private static final SdkField<SpatialStaticFile> SPATIAL_STATIC_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpatialStaticFile").getter(StaticFile.getter(StaticFile::spatialStaticFile)).setter(StaticFile.setter(Builder::spatialStaticFile)).constructor(SpatialStaticFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpatialStaticFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_STATIC_FILE_FIELD, SPATIAL_STATIC_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StaticFile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ImageStaticFile imageStaticFile;
    private final SpatialStaticFile spatialStaticFile;

    private StaticFile(BuilderImpl builder) {
        this.imageStaticFile = builder.imageStaticFile;
        this.spatialStaticFile = builder.spatialStaticFile;
    }

    public final ImageStaticFile imageStaticFile() {
        return this.imageStaticFile;
    }

    public final SpatialStaticFile spatialStaticFile() {
        return this.spatialStaticFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageStaticFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialStaticFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticFile)) {
            return false;
        }
        StaticFile other = (StaticFile)obj;
        return Objects.equals(this.imageStaticFile(), other.imageStaticFile()) && Objects.equals(this.spatialStaticFile(), other.spatialStaticFile());
    }

    public final String toString() {
        return ToString.builder((String)"StaticFile").add("ImageStaticFile", (Object)this.imageStaticFile()).add("SpatialStaticFile", (Object)this.spatialStaticFile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageStaticFile": {
                return Optional.ofNullable(clazz.cast(this.imageStaticFile()));
            }
            case "SpatialStaticFile": {
                return Optional.ofNullable(clazz.cast(this.spatialStaticFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageStaticFile", IMAGE_STATIC_FILE_FIELD);
        map.put("SpatialStaticFile", SPATIAL_STATIC_FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticFile, T> g) {
        return obj -> g.apply((StaticFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageStaticFile imageStaticFile;
        private SpatialStaticFile spatialStaticFile;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticFile model) {
            this.imageStaticFile(model.imageStaticFile);
            this.spatialStaticFile(model.spatialStaticFile);
        }

        public final ImageStaticFile.Builder getImageStaticFile() {
            return this.imageStaticFile != null ? this.imageStaticFile.toBuilder() : null;
        }

        public final void setImageStaticFile(ImageStaticFile.BuilderImpl imageStaticFile) {
            this.imageStaticFile = imageStaticFile != null ? imageStaticFile.build() : null;
        }

        @Override
        public final Builder imageStaticFile(ImageStaticFile imageStaticFile) {
            this.imageStaticFile = imageStaticFile;
            return this;
        }

        public final SpatialStaticFile.Builder getSpatialStaticFile() {
            return this.spatialStaticFile != null ? this.spatialStaticFile.toBuilder() : null;
        }

        public final void setSpatialStaticFile(SpatialStaticFile.BuilderImpl spatialStaticFile) {
            this.spatialStaticFile = spatialStaticFile != null ? spatialStaticFile.build() : null;
        }

        @Override
        public final Builder spatialStaticFile(SpatialStaticFile spatialStaticFile) {
            this.spatialStaticFile = spatialStaticFile;
            return this;
        }

        public StaticFile build() {
            return new StaticFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StaticFile> {
        public Builder imageStaticFile(ImageStaticFile var1);

        default public Builder imageStaticFile(Consumer<ImageStaticFile.Builder> imageStaticFile) {
            return this.imageStaticFile((ImageStaticFile)((ImageStaticFile.Builder)ImageStaticFile.builder().applyMutation(imageStaticFile)).build());
        }

        public Builder spatialStaticFile(SpatialStaticFile var1);

        default public Builder spatialStaticFile(Consumer<SpatialStaticFile.Builder> spatialStaticFile) {
            return this.spatialStaticFile((SpatialStaticFile)((SpatialStaticFile.Builder)SpatialStaticFile.builder().applyMutation(spatialStaticFile)).build());
        }
    }
}

