/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceErrorInfoType {
    ACCESS_DENIED("ACCESS_DENIED"),
    COPY_SOURCE_NOT_FOUND("COPY_SOURCE_NOT_FOUND"),
    TIMEOUT("TIMEOUT"),
    ENGINE_VERSION_NOT_SUPPORTED("ENGINE_VERSION_NOT_SUPPORTED"),
    UNKNOWN_HOST("UNKNOWN_HOST"),
    GENERIC_SQL_FAILURE("GENERIC_SQL_FAILURE"),
    CONFLICT("CONFLICT"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceErrorInfoType> VALUE_MAP;
    private final String value;

    private DataSourceErrorInfoType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceErrorInfoType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceErrorInfoType> knownValues() {
        EnumSet<DataSourceErrorInfoType> knownValues = EnumSet.allOf(DataSourceErrorInfoType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceErrorInfoType.class, DataSourceErrorInfoType::toString);
    }
}

