/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DataSetSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;

public class SearchDataSetsIterable
implements SdkIterable<SearchDataSetsResponse> {
    private final QuickSightClient client;
    private final SearchDataSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDataSetsIterable(QuickSightClient client, SearchDataSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchDataSetsResponseFetcher();
    }

    public Iterator<SearchDataSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSetSummary> dataSetSummaries() {
        Function<SearchDataSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataSetSummaries() != null) {
                return response.dataSetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDataSetsResponseFetcher
    implements SyncPageFetcher<SearchDataSetsResponse> {
        private SearchDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(SearchDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDataSetsResponse nextPage(SearchDataSetsResponse previousPage) {
            if (previousPage == null) {
                return SearchDataSetsIterable.this.client.searchDataSets(SearchDataSetsIterable.this.firstRequest);
            }
            return SearchDataSetsIterable.this.client.searchDataSets((SearchDataSetsRequest)((Object)SearchDataSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

