/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.CustomContentImageScalingConfiguration;
import software.amazon.awssdk.services.quicksight.model.CustomContentType;
import software.amazon.awssdk.services.quicksight.model.VisualInteractionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomContentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomContentConfiguration> {
    private static final SdkField<String> CONTENT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentUrl").getter(CustomContentConfiguration.getter(CustomContentConfiguration::contentUrl)).setter(CustomContentConfiguration.setter(Builder::contentUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentUrl").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(CustomContentConfiguration.getter(CustomContentConfiguration::contentTypeAsString)).setter(CustomContentConfiguration.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<String> IMAGE_SCALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageScaling").getter(CustomContentConfiguration.getter(CustomContentConfiguration::imageScalingAsString)).setter(CustomContentConfiguration.setter(Builder::imageScaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageScaling").build()}).build();
    private static final SdkField<VisualInteractionOptions> INTERACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interactions").getter(CustomContentConfiguration.getter(CustomContentConfiguration::interactions)).setter(CustomContentConfiguration.setter(Builder::interactions)).constructor(VisualInteractionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interactions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_URL_FIELD, CONTENT_TYPE_FIELD, IMAGE_SCALING_FIELD, INTERACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomContentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contentUrl;
    private final String contentType;
    private final String imageScaling;
    private final VisualInteractionOptions interactions;

    private CustomContentConfiguration(BuilderImpl builder) {
        this.contentUrl = builder.contentUrl;
        this.contentType = builder.contentType;
        this.imageScaling = builder.imageScaling;
        this.interactions = builder.interactions;
    }

    public final String contentUrl() {
        return this.contentUrl;
    }

    public final CustomContentType contentType() {
        return CustomContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final CustomContentImageScalingConfiguration imageScaling() {
        return CustomContentImageScalingConfiguration.fromValue(this.imageScaling);
    }

    public final String imageScalingAsString() {
        return this.imageScaling;
    }

    public final VisualInteractionOptions interactions() {
        return this.interactions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomContentConfiguration)) {
            return false;
        }
        CustomContentConfiguration other = (CustomContentConfiguration)obj;
        return Objects.equals(this.contentUrl(), other.contentUrl()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.imageScalingAsString(), other.imageScalingAsString()) && Objects.equals(this.interactions(), other.interactions());
    }

    public final String toString() {
        return ToString.builder((String)"CustomContentConfiguration").add("ContentUrl", (Object)this.contentUrl()).add("ContentType", (Object)this.contentTypeAsString()).add("ImageScaling", (Object)this.imageScalingAsString()).add("Interactions", (Object)this.interactions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentUrl": {
                return Optional.ofNullable(clazz.cast(this.contentUrl()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "ImageScaling": {
                return Optional.ofNullable(clazz.cast(this.imageScalingAsString()));
            }
            case "Interactions": {
                return Optional.ofNullable(clazz.cast(this.interactions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContentUrl", CONTENT_URL_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("ImageScaling", IMAGE_SCALING_FIELD);
        map.put("Interactions", INTERACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomContentConfiguration, T> g) {
        return obj -> g.apply((CustomContentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contentUrl;
        private String contentType;
        private String imageScaling;
        private VisualInteractionOptions interactions;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomContentConfiguration model) {
            this.contentUrl(model.contentUrl);
            this.contentType(model.contentType);
            this.imageScaling(model.imageScaling);
            this.interactions(model.interactions);
        }

        public final String getContentUrl() {
            return this.contentUrl;
        }

        public final void setContentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
        }

        @Override
        public final Builder contentUrl(String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CustomContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final String getImageScaling() {
            return this.imageScaling;
        }

        public final void setImageScaling(String imageScaling) {
            this.imageScaling = imageScaling;
        }

        @Override
        public final Builder imageScaling(String imageScaling) {
            this.imageScaling = imageScaling;
            return this;
        }

        @Override
        public final Builder imageScaling(CustomContentImageScalingConfiguration imageScaling) {
            this.imageScaling(imageScaling == null ? null : imageScaling.toString());
            return this;
        }

        public final VisualInteractionOptions.Builder getInteractions() {
            return this.interactions != null ? this.interactions.toBuilder() : null;
        }

        public final void setInteractions(VisualInteractionOptions.BuilderImpl interactions) {
            this.interactions = interactions != null ? interactions.build() : null;
        }

        @Override
        public final Builder interactions(VisualInteractionOptions interactions) {
            this.interactions = interactions;
            return this;
        }

        public CustomContentConfiguration build() {
            return new CustomContentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomContentConfiguration> {
        public Builder contentUrl(String var1);

        public Builder contentType(String var1);

        public Builder contentType(CustomContentType var1);

        public Builder imageScaling(String var1);

        public Builder imageScaling(CustomContentImageScalingConfiguration var1);

        public Builder interactions(VisualInteractionOptions var1);

        default public Builder interactions(Consumer<VisualInteractionOptions.Builder> interactions) {
            return this.interactions((VisualInteractionOptions)((VisualInteractionOptions.Builder)VisualInteractionOptions.builder().applyMutation(interactions)).build());
        }
    }
}

