/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InputColumn;
import software.amazon.awssdk.services.quicksight.model.InputColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalTable> {
    private static final SdkField<String> DATA_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceArn").getter(RelationalTable.getter(RelationalTable::dataSourceArn)).setter(RelationalTable.setter(Builder::dataSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceArn").build()}).build();
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(RelationalTable.getter(RelationalTable::catalog)).setter(RelationalTable.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(RelationalTable.getter(RelationalTable::schema)).setter(RelationalTable.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RelationalTable.getter(RelationalTable::name)).setter(RelationalTable.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputColumns").getter(RelationalTable.getter(RelationalTable::inputColumns)).setter(RelationalTable.setter(Builder::inputColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ARN_FIELD, CATALOG_FIELD, SCHEMA_FIELD, NAME_FIELD, INPUT_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelationalTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSourceArn;
    private final String catalog;
    private final String schema;
    private final String name;
    private final List<InputColumn> inputColumns;

    private RelationalTable(BuilderImpl builder) {
        this.dataSourceArn = builder.dataSourceArn;
        this.catalog = builder.catalog;
        this.schema = builder.schema;
        this.name = builder.name;
        this.inputColumns = builder.inputColumns;
    }

    public final String dataSourceArn() {
        return this.dataSourceArn;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final String schema() {
        return this.schema;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputColumns() {
        return this.inputColumns != null && !(this.inputColumns instanceof SdkAutoConstructList);
    }

    public final List<InputColumn> inputColumns() {
        return this.inputColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputColumns() ? this.inputColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalTable)) {
            return false;
        }
        RelationalTable other = (RelationalTable)obj;
        return Objects.equals(this.dataSourceArn(), other.dataSourceArn()) && Objects.equals(this.catalog(), other.catalog()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.name(), other.name()) && this.hasInputColumns() == other.hasInputColumns() && Objects.equals(this.inputColumns(), other.inputColumns());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalTable").add("DataSourceArn", (Object)this.dataSourceArn()).add("Catalog", (Object)this.catalog()).add("Schema", (Object)this.schema()).add("Name", (Object)this.name()).add("InputColumns", this.hasInputColumns() ? this.inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSourceArn": {
                return Optional.ofNullable(clazz.cast(this.dataSourceArn()));
            }
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InputColumns": {
                return Optional.ofNullable(clazz.cast(this.inputColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSourceArn", DATA_SOURCE_ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelationalTable, T> g) {
        return obj -> g.apply((RelationalTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSourceArn;
        private String catalog;
        private String schema;
        private String name;
        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalTable model) {
            this.dataSourceArn(model.dataSourceArn);
            this.catalog(model.catalog);
            this.schema(model.schema);
            this.name(model.name);
            this.inputColumns(model.inputColumns);
        }

        public final String getDataSourceArn() {
            return this.dataSourceArn;
        }

        public final void setDataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
        }

        @Override
        public final Builder dataSourceArn(String dataSourceArn) {
            this.dataSourceArn = dataSourceArn;
            return this;
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn ... inputColumns) {
            this.inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder> ... inputColumns) {
            this.inputColumns(Stream.of(inputColumns).map(c -> (InputColumn)((InputColumn.Builder)InputColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RelationalTable build() {
            return new RelationalTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalTable> {
        public Builder dataSourceArn(String var1);

        public Builder catalog(String var1);

        public Builder schema(String var1);

        public Builder name(String var1);

        public Builder inputColumns(Collection<InputColumn> var1);

        public Builder inputColumns(InputColumn ... var1);

        public Builder inputColumns(Consumer<InputColumn.Builder> ... var1);
    }
}

