/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.PaginationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BoxPlotSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BoxPlotSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategorySort").getter(BoxPlotSortConfiguration.getter(BoxPlotSortConfiguration::categorySort)).setter(BoxPlotSortConfiguration.setter(Builder::categorySort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PaginationConfiguration> PAGINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PaginationConfiguration").getter(BoxPlotSortConfiguration.getter(BoxPlotSortConfiguration::paginationConfiguration)).setter(BoxPlotSortConfiguration.setter(Builder::paginationConfiguration)).constructor(PaginationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD, PAGINATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BoxPlotSortConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> categorySort;
    private final PaginationConfiguration paginationConfiguration;

    private BoxPlotSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.paginationConfiguration = builder.paginationConfiguration;
    }

    public final boolean hasCategorySort() {
        return this.categorySort != null && !(this.categorySort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> categorySort() {
        return this.categorySort;
    }

    public final PaginationConfiguration paginationConfiguration() {
        return this.paginationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorySort() ? this.categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoxPlotSortConfiguration)) {
            return false;
        }
        BoxPlotSortConfiguration other = (BoxPlotSortConfiguration)obj;
        return this.hasCategorySort() == other.hasCategorySort() && Objects.equals(this.categorySort(), other.categorySort()) && Objects.equals(this.paginationConfiguration(), other.paginationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BoxPlotSortConfiguration").add("CategorySort", this.hasCategorySort() ? this.categorySort() : null).add("PaginationConfiguration", (Object)this.paginationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategorySort": {
                return Optional.ofNullable(clazz.cast(this.categorySort()));
            }
            case "PaginationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paginationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CategorySort", CATEGORY_SORT_FIELD);
        map.put("PaginationConfiguration", PAGINATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BoxPlotSortConfiguration, T> g) {
        return obj -> g.apply((BoxPlotSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();
        private PaginationConfiguration paginationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BoxPlotSortConfiguration model) {
            this.categorySort(model.categorySort);
            this.paginationConfiguration(model.paginationConfiguration);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions ... categorySort) {
            this.categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder> ... categorySort) {
            this.categorySort(Stream.of(categorySort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final PaginationConfiguration.Builder getPaginationConfiguration() {
            return this.paginationConfiguration != null ? this.paginationConfiguration.toBuilder() : null;
        }

        public final void setPaginationConfiguration(PaginationConfiguration.BuilderImpl paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration != null ? paginationConfiguration.build() : null;
        }

        @Override
        public final Builder paginationConfiguration(PaginationConfiguration paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration;
            return this;
        }

        public BoxPlotSortConfiguration build() {
            return new BoxPlotSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BoxPlotSortConfiguration> {
        public Builder categorySort(Collection<FieldSortOptions> var1);

        public Builder categorySort(FieldSortOptions ... var1);

        public Builder categorySort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder paginationConfiguration(PaginationConfiguration var1);

        default public Builder paginationConfiguration(Consumer<PaginationConfiguration.Builder> paginationConfiguration) {
            return this.paginationConfiguration((PaginationConfiguration)((PaginationConfiguration.Builder)PaginationConfiguration.builder().applyMutation(paginationConfiguration)).build());
        }
    }
}

