/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CommitMode {
    AUTO("AUTO"),
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CommitMode> VALUE_MAP;
    private final String value;

    private CommitMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CommitMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CommitMode> knownValues() {
        EnumSet<CommitMode> knownValues = EnumSet.allOf(CommitMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CommitMode.class, CommitMode::toString);
    }
}

