/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.Parameters;
import software.amazon.awssdk.services.quicksight.model.SnapshotDestinationConfiguration;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileGroup;
import software.amazon.awssdk.services.quicksight.model.SnapshotFileGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotConfiguration> {
    private static final SdkField<List<SnapshotFileGroup>> FILE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FileGroups").getter(SnapshotConfiguration.getter(SnapshotConfiguration::fileGroups)).setter(SnapshotConfiguration.setter(Builder::fileGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotFileGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SnapshotDestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationConfiguration").getter(SnapshotConfiguration.getter(SnapshotConfiguration::destinationConfiguration)).setter(SnapshotConfiguration.setter(Builder::destinationConfiguration)).constructor(SnapshotDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfiguration").build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(SnapshotConfiguration.getter(SnapshotConfiguration::parameters)).setter(SnapshotConfiguration.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_GROUPS_FIELD, DESTINATION_CONFIGURATION_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnapshotConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SnapshotFileGroup> fileGroups;
    private final SnapshotDestinationConfiguration destinationConfiguration;
    private final Parameters parameters;

    private SnapshotConfiguration(BuilderImpl builder) {
        this.fileGroups = builder.fileGroups;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.parameters = builder.parameters;
    }

    public final boolean hasFileGroups() {
        return this.fileGroups != null && !(this.fileGroups instanceof SdkAutoConstructList);
    }

    public final List<SnapshotFileGroup> fileGroups() {
        return this.fileGroups;
    }

    public final SnapshotDestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final Parameters parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileGroups() ? this.fileGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotConfiguration)) {
            return false;
        }
        SnapshotConfiguration other = (SnapshotConfiguration)obj;
        return this.hasFileGroups() == other.hasFileGroups() && Objects.equals(this.fileGroups(), other.fileGroups()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotConfiguration").add("FileGroups", this.hasFileGroups() ? this.fileGroups() : null).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileGroups": {
                return Optional.ofNullable(clazz.cast(this.fileGroups()));
            }
            case "DestinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FileGroups", FILE_GROUPS_FIELD);
        map.put("DestinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotConfiguration, T> g) {
        return obj -> g.apply((SnapshotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SnapshotFileGroup> fileGroups = DefaultSdkAutoConstructList.getInstance();
        private SnapshotDestinationConfiguration destinationConfiguration;
        private Parameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotConfiguration model) {
            this.fileGroups(model.fileGroups);
            this.destinationConfiguration(model.destinationConfiguration);
            this.parameters(model.parameters);
        }

        public final List<SnapshotFileGroup.Builder> getFileGroups() {
            List<SnapshotFileGroup.Builder> result = SnapshotFileGroupListCopier.copyToBuilder(this.fileGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileGroups(Collection<SnapshotFileGroup.BuilderImpl> fileGroups) {
            this.fileGroups = SnapshotFileGroupListCopier.copyFromBuilder(fileGroups);
        }

        @Override
        public final Builder fileGroups(Collection<SnapshotFileGroup> fileGroups) {
            this.fileGroups = SnapshotFileGroupListCopier.copy(fileGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(SnapshotFileGroup ... fileGroups) {
            this.fileGroups(Arrays.asList(fileGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileGroups(Consumer<SnapshotFileGroup.Builder> ... fileGroups) {
            this.fileGroups(Stream.of(fileGroups).map(c -> (SnapshotFileGroup)((SnapshotFileGroup.Builder)SnapshotFileGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SnapshotDestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(SnapshotDestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(SnapshotDestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public SnapshotConfiguration build() {
            return new SnapshotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotConfiguration> {
        public Builder fileGroups(Collection<SnapshotFileGroup> var1);

        public Builder fileGroups(SnapshotFileGroup ... var1);

        public Builder fileGroups(Consumer<SnapshotFileGroup.Builder> ... var1);

        public Builder destinationConfiguration(SnapshotDestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<SnapshotDestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((SnapshotDestinationConfiguration)((SnapshotDestinationConfiguration.Builder)SnapshotDestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }
    }
}

