/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.LogicalTableSource;
import software.amazon.awssdk.services.quicksight.model.TransformOperation;
import software.amazon.awssdk.services.quicksight.model.TransformOperationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogicalTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogicalTable> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(LogicalTable.getter(LogicalTable::alias)).setter(LogicalTable.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<List<TransformOperation>> DATA_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataTransforms").getter(LogicalTable.getter(LogicalTable::dataTransforms)).setter(LogicalTable.setter(Builder::dataTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransformOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LogicalTableSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(LogicalTable.getter(LogicalTable::source)).setter(LogicalTable.setter(Builder::source)).constructor(LogicalTableSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, DATA_TRANSFORMS_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogicalTable.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final List<TransformOperation> dataTransforms;
    private final LogicalTableSource source;

    private LogicalTable(BuilderImpl builder) {
        this.alias = builder.alias;
        this.dataTransforms = builder.dataTransforms;
        this.source = builder.source;
    }

    public final String alias() {
        return this.alias;
    }

    public final boolean hasDataTransforms() {
        return this.dataTransforms != null && !(this.dataTransforms instanceof SdkAutoConstructList);
    }

    public final List<TransformOperation> dataTransforms() {
        return this.dataTransforms;
    }

    public final LogicalTableSource source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTransforms() ? this.dataTransforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalTable)) {
            return false;
        }
        LogicalTable other = (LogicalTable)obj;
        return Objects.equals(this.alias(), other.alias()) && this.hasDataTransforms() == other.hasDataTransforms() && Objects.equals(this.dataTransforms(), other.dataTransforms()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"LogicalTable").add("Alias", (Object)this.alias()).add("DataTransforms", this.hasDataTransforms() ? this.dataTransforms() : null).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "DataTransforms": {
                return Optional.ofNullable(clazz.cast(this.dataTransforms()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("DataTransforms", DATA_TRANSFORMS_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogicalTable, T> g) {
        return obj -> g.apply((LogicalTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private List<TransformOperation> dataTransforms = DefaultSdkAutoConstructList.getInstance();
        private LogicalTableSource source;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalTable model) {
            this.alias(model.alias);
            this.dataTransforms(model.dataTransforms);
            this.source(model.source);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final List<TransformOperation.Builder> getDataTransforms() {
            List<TransformOperation.Builder> result = TransformOperationListCopier.copyToBuilder(this.dataTransforms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataTransforms(Collection<TransformOperation.BuilderImpl> dataTransforms) {
            this.dataTransforms = TransformOperationListCopier.copyFromBuilder(dataTransforms);
        }

        @Override
        public final Builder dataTransforms(Collection<TransformOperation> dataTransforms) {
            this.dataTransforms = TransformOperationListCopier.copy(dataTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransforms(TransformOperation ... dataTransforms) {
            this.dataTransforms(Arrays.asList(dataTransforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTransforms(Consumer<TransformOperation.Builder> ... dataTransforms) {
            this.dataTransforms(Stream.of(dataTransforms).map(c -> (TransformOperation)((TransformOperation.Builder)TransformOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LogicalTableSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(LogicalTableSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(LogicalTableSource source) {
            this.source = source;
            return this;
        }

        public LogicalTable build() {
            return new LogicalTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogicalTable> {
        public Builder alias(String var1);

        public Builder dataTransforms(Collection<TransformOperation> var1);

        public Builder dataTransforms(TransformOperation ... var1);

        public Builder dataTransforms(Consumer<TransformOperation.Builder> ... var1);

        public Builder source(LogicalTableSource var1);

        default public Builder source(Consumer<LogicalTableSource.Builder> source) {
            return this.source((LogicalTableSource)((LogicalTableSource.Builder)LogicalTableSource.builder().applyMutation(source)).build());
        }
    }
}

