/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.BrandColorPalette;
import software.amazon.awssdk.services.quicksight.model.BrandElementStyle;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationTheme
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationTheme> {
    private static final SdkField<BrandColorPalette> BRAND_COLOR_PALETTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrandColorPalette").getter(ApplicationTheme.getter(ApplicationTheme::brandColorPalette)).setter(ApplicationTheme.setter(Builder::brandColorPalette)).constructor(BrandColorPalette::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandColorPalette").build()}).build();
    private static final SdkField<BrandElementStyle> BRAND_ELEMENT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrandElementStyle").getter(ApplicationTheme.getter(ApplicationTheme::brandElementStyle)).setter(ApplicationTheme.setter(Builder::brandElementStyle)).constructor(BrandElementStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrandElementStyle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRAND_COLOR_PALETTE_FIELD, BRAND_ELEMENT_STYLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationTheme.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BrandColorPalette brandColorPalette;
    private final BrandElementStyle brandElementStyle;

    private ApplicationTheme(BuilderImpl builder) {
        this.brandColorPalette = builder.brandColorPalette;
        this.brandElementStyle = builder.brandElementStyle;
    }

    public final BrandColorPalette brandColorPalette() {
        return this.brandColorPalette;
    }

    public final BrandElementStyle brandElementStyle() {
        return this.brandElementStyle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brandColorPalette());
        hashCode = 31 * hashCode + Objects.hashCode(this.brandElementStyle());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationTheme)) {
            return false;
        }
        ApplicationTheme other = (ApplicationTheme)obj;
        return Objects.equals(this.brandColorPalette(), other.brandColorPalette()) && Objects.equals(this.brandElementStyle(), other.brandElementStyle());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationTheme").add("BrandColorPalette", (Object)this.brandColorPalette()).add("BrandElementStyle", (Object)this.brandElementStyle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrandColorPalette": {
                return Optional.ofNullable(clazz.cast(this.brandColorPalette()));
            }
            case "BrandElementStyle": {
                return Optional.ofNullable(clazz.cast(this.brandElementStyle()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BrandColorPalette", BRAND_COLOR_PALETTE_FIELD);
        map.put("BrandElementStyle", BRAND_ELEMENT_STYLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationTheme, T> g) {
        return obj -> g.apply((ApplicationTheme)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BrandColorPalette brandColorPalette;
        private BrandElementStyle brandElementStyle;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationTheme model) {
            this.brandColorPalette(model.brandColorPalette);
            this.brandElementStyle(model.brandElementStyle);
        }

        public final BrandColorPalette.Builder getBrandColorPalette() {
            return this.brandColorPalette != null ? this.brandColorPalette.toBuilder() : null;
        }

        public final void setBrandColorPalette(BrandColorPalette.BuilderImpl brandColorPalette) {
            this.brandColorPalette = brandColorPalette != null ? brandColorPalette.build() : null;
        }

        @Override
        public final Builder brandColorPalette(BrandColorPalette brandColorPalette) {
            this.brandColorPalette = brandColorPalette;
            return this;
        }

        public final BrandElementStyle.Builder getBrandElementStyle() {
            return this.brandElementStyle != null ? this.brandElementStyle.toBuilder() : null;
        }

        public final void setBrandElementStyle(BrandElementStyle.BuilderImpl brandElementStyle) {
            this.brandElementStyle = brandElementStyle != null ? brandElementStyle.build() : null;
        }

        @Override
        public final Builder brandElementStyle(BrandElementStyle brandElementStyle) {
            this.brandElementStyle = brandElementStyle;
            return this;
        }

        public ApplicationTheme build() {
            return new ApplicationTheme(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationTheme> {
        public Builder brandColorPalette(BrandColorPalette var1);

        default public Builder brandColorPalette(Consumer<BrandColorPalette.Builder> brandColorPalette) {
            return this.brandColorPalette((BrandColorPalette)((BrandColorPalette.Builder)BrandColorPalette.builder().applyMutation(brandColorPalette)).build());
        }

        public Builder brandElementStyle(BrandElementStyle var1);

        default public Builder brandElementStyle(Consumer<BrandElementStyle.Builder> brandElementStyle) {
            return this.brandElementStyle((BrandElementStyle)((BrandElementStyle.Builder)BrandElementStyle.builder().applyMutation(brandElementStyle)).build());
        }
    }
}

