/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Identifier;
import software.amazon.awssdk.services.quicksight.model.TopicSortDirection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicSortClause
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicSortClause> {
    private static final SdkField<Identifier> OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operand").getter(TopicSortClause.getter(TopicSortClause::operand)).setter(TopicSortClause.setter(Builder::operand)).constructor(Identifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operand").build()}).build();
    private static final SdkField<String> SORT_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortDirection").getter(TopicSortClause.getter(TopicSortClause::sortDirectionAsString)).setter(TopicSortClause.setter(Builder::sortDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortDirection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERAND_FIELD, SORT_DIRECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicSortClause.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Identifier operand;
    private final String sortDirection;

    private TopicSortClause(BuilderImpl builder) {
        this.operand = builder.operand;
        this.sortDirection = builder.sortDirection;
    }

    public final Identifier operand() {
        return this.operand;
    }

    public final TopicSortDirection sortDirection() {
        return TopicSortDirection.fromValue(this.sortDirection);
    }

    public final String sortDirectionAsString() {
        return this.sortDirection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operand());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortDirectionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicSortClause)) {
            return false;
        }
        TopicSortClause other = (TopicSortClause)obj;
        return Objects.equals(this.operand(), other.operand()) && Objects.equals(this.sortDirectionAsString(), other.sortDirectionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopicSortClause").add("Operand", (Object)this.operand()).add("SortDirection", (Object)this.sortDirectionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operand": {
                return Optional.ofNullable(clazz.cast(this.operand()));
            }
            case "SortDirection": {
                return Optional.ofNullable(clazz.cast(this.sortDirectionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Operand", OPERAND_FIELD);
        map.put("SortDirection", SORT_DIRECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicSortClause, T> g) {
        return obj -> g.apply((TopicSortClause)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Identifier operand;
        private String sortDirection;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicSortClause model) {
            this.operand(model.operand);
            this.sortDirection(model.sortDirection);
        }

        public final Identifier.Builder getOperand() {
            return this.operand != null ? this.operand.toBuilder() : null;
        }

        public final void setOperand(Identifier.BuilderImpl operand) {
            this.operand = operand != null ? operand.build() : null;
        }

        @Override
        public final Builder operand(Identifier operand) {
            this.operand = operand;
            return this;
        }

        public final String getSortDirection() {
            return this.sortDirection;
        }

        public final void setSortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        @Override
        public final Builder sortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        @Override
        public final Builder sortDirection(TopicSortDirection sortDirection) {
            this.sortDirection(sortDirection == null ? null : sortDirection.toString());
            return this;
        }

        public TopicSortClause build() {
            return new TopicSortClause(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicSortClause> {
        public Builder operand(Identifier var1);

        default public Builder operand(Consumer<Identifier.Builder> operand) {
            return this.operand((Identifier)((Identifier.Builder)Identifier.builder().applyMutation(operand)).build());
        }

        public Builder sortDirection(String var1);

        public Builder sortDirection(TopicSortDirection var1);
    }
}

