/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunnelChartSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunnelChartSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> CATEGORY_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CategorySort").getter(FunnelChartSortConfiguration.getter(FunnelChartSortConfiguration::categorySort)).setter(FunnelChartSortConfiguration.setter(Builder::categorySort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategorySort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> CATEGORY_ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryItemsLimit").getter(FunnelChartSortConfiguration.getter(FunnelChartSortConfiguration::categoryItemsLimit)).setter(FunnelChartSortConfiguration.setter(Builder::categoryItemsLimit)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryItemsLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_SORT_FIELD, CATEGORY_ITEMS_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunnelChartSortConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> categorySort;
    private final ItemsLimitConfiguration categoryItemsLimit;

    private FunnelChartSortConfiguration(BuilderImpl builder) {
        this.categorySort = builder.categorySort;
        this.categoryItemsLimit = builder.categoryItemsLimit;
    }

    public final boolean hasCategorySort() {
        return this.categorySort != null && !(this.categorySort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> categorySort() {
        return this.categorySort;
    }

    public final ItemsLimitConfiguration categoryItemsLimit() {
        return this.categoryItemsLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategorySort() ? this.categorySort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryItemsLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunnelChartSortConfiguration)) {
            return false;
        }
        FunnelChartSortConfiguration other = (FunnelChartSortConfiguration)obj;
        return this.hasCategorySort() == other.hasCategorySort() && Objects.equals(this.categorySort(), other.categorySort()) && Objects.equals(this.categoryItemsLimit(), other.categoryItemsLimit());
    }

    public final String toString() {
        return ToString.builder((String)"FunnelChartSortConfiguration").add("CategorySort", this.hasCategorySort() ? this.categorySort() : null).add("CategoryItemsLimit", (Object)this.categoryItemsLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategorySort": {
                return Optional.ofNullable(clazz.cast(this.categorySort()));
            }
            case "CategoryItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.categoryItemsLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CategorySort", CATEGORY_SORT_FIELD);
        map.put("CategoryItemsLimit", CATEGORY_ITEMS_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunnelChartSortConfiguration, T> g) {
        return obj -> g.apply((FunnelChartSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> categorySort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration categoryItemsLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(FunnelChartSortConfiguration model) {
            this.categorySort(model.categorySort);
            this.categoryItemsLimit(model.categoryItemsLimit);
        }

        public final List<FieldSortOptions.Builder> getCategorySort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.categorySort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCategorySort(Collection<FieldSortOptions.BuilderImpl> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copyFromBuilder(categorySort);
        }

        @Override
        public final Builder categorySort(Collection<FieldSortOptions> categorySort) {
            this.categorySort = FieldSortOptionsListCopier.copy(categorySort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(FieldSortOptions ... categorySort) {
            this.categorySort(Arrays.asList(categorySort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder categorySort(Consumer<FieldSortOptions.Builder> ... categorySort) {
            this.categorySort(Stream.of(categorySort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getCategoryItemsLimit() {
            return this.categoryItemsLimit != null ? this.categoryItemsLimit.toBuilder() : null;
        }

        public final void setCategoryItemsLimit(ItemsLimitConfiguration.BuilderImpl categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit != null ? categoryItemsLimit.build() : null;
        }

        @Override
        public final Builder categoryItemsLimit(ItemsLimitConfiguration categoryItemsLimit) {
            this.categoryItemsLimit = categoryItemsLimit;
            return this;
        }

        public FunnelChartSortConfiguration build() {
            return new FunnelChartSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunnelChartSortConfiguration> {
        public Builder categorySort(Collection<FieldSortOptions> var1);

        public Builder categorySort(FieldSortOptions ... var1);

        public Builder categorySort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder categoryItemsLimit(ItemsLimitConfiguration var1);

        default public Builder categoryItemsLimit(Consumer<ItemsLimitConfiguration.Builder> categoryItemsLimit) {
            return this.categoryItemsLimit((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(categoryItemsLimit)).build());
        }
    }
}

