/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DatasetMetadata;
import software.amazon.awssdk.services.quicksight.model.DatasetsCopier;
import software.amazon.awssdk.services.quicksight.model.TopicConfigOptions;
import software.amazon.awssdk.services.quicksight.model.TopicUserExperienceVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TopicDetails.getter(TopicDetails::name)).setter(TopicDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TopicDetails.getter(TopicDetails::description)).setter(TopicDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> USER_EXPERIENCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserExperienceVersion").getter(TopicDetails.getter(TopicDetails::userExperienceVersionAsString)).setter(TopicDetails.setter(Builder::userExperienceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserExperienceVersion").build()}).build();
    private static final SdkField<List<DatasetMetadata>> DATA_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSets").getter(TopicDetails.getter(TopicDetails::dataSets)).setter(TopicDetails.setter(Builder::dataSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TopicConfigOptions> CONFIG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigOptions").getter(TopicDetails.getter(TopicDetails::configOptions)).setter(TopicDetails.setter(Builder::configOptions)).constructor(TopicConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, USER_EXPERIENCE_VERSION_FIELD, DATA_SETS_FIELD, CONFIG_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TopicDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String userExperienceVersion;
    private final List<DatasetMetadata> dataSets;
    private final TopicConfigOptions configOptions;

    private TopicDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.userExperienceVersion = builder.userExperienceVersion;
        this.dataSets = builder.dataSets;
        this.configOptions = builder.configOptions;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final TopicUserExperienceVersion userExperienceVersion() {
        return TopicUserExperienceVersion.fromValue(this.userExperienceVersion);
    }

    public final String userExperienceVersionAsString() {
        return this.userExperienceVersion;
    }

    public final boolean hasDataSets() {
        return this.dataSets != null && !(this.dataSets instanceof SdkAutoConstructList);
    }

    public final List<DatasetMetadata> dataSets() {
        return this.dataSets;
    }

    public final TopicConfigOptions configOptions() {
        return this.configOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.userExperienceVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSets() ? this.dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicDetails)) {
            return false;
        }
        TopicDetails other = (TopicDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.userExperienceVersionAsString(), other.userExperienceVersionAsString()) && this.hasDataSets() == other.hasDataSets() && Objects.equals(this.dataSets(), other.dataSets()) && Objects.equals(this.configOptions(), other.configOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TopicDetails").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("UserExperienceVersion", (Object)this.userExperienceVersionAsString()).add("DataSets", this.hasDataSets() ? this.dataSets() : null).add("ConfigOptions", (Object)this.configOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UserExperienceVersion": {
                return Optional.ofNullable(clazz.cast(this.userExperienceVersionAsString()));
            }
            case "DataSets": {
                return Optional.ofNullable(clazz.cast(this.dataSets()));
            }
            case "ConfigOptions": {
                return Optional.ofNullable(clazz.cast(this.configOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UserExperienceVersion", USER_EXPERIENCE_VERSION_FIELD);
        map.put("DataSets", DATA_SETS_FIELD);
        map.put("ConfigOptions", CONFIG_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TopicDetails, T> g) {
        return obj -> g.apply((TopicDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String userExperienceVersion;
        private List<DatasetMetadata> dataSets = DefaultSdkAutoConstructList.getInstance();
        private TopicConfigOptions configOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicDetails model) {
            this.name(model.name);
            this.description(model.description);
            this.userExperienceVersion(model.userExperienceVersion);
            this.dataSets(model.dataSets);
            this.configOptions(model.configOptions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserExperienceVersion() {
            return this.userExperienceVersion;
        }

        public final void setUserExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
        }

        @Override
        public final Builder userExperienceVersion(String userExperienceVersion) {
            this.userExperienceVersion = userExperienceVersion;
            return this;
        }

        @Override
        public final Builder userExperienceVersion(TopicUserExperienceVersion userExperienceVersion) {
            this.userExperienceVersion(userExperienceVersion == null ? null : userExperienceVersion.toString());
            return this;
        }

        public final List<DatasetMetadata.Builder> getDataSets() {
            List<DatasetMetadata.Builder> result = DatasetsCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DatasetMetadata.BuilderImpl> dataSets) {
            this.dataSets = DatasetsCopier.copyFromBuilder(dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DatasetMetadata> dataSets) {
            this.dataSets = DatasetsCopier.copy(dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DatasetMetadata ... dataSets) {
            this.dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DatasetMetadata.Builder> ... dataSets) {
            this.dataSets(Stream.of(dataSets).map(c -> (DatasetMetadata)((DatasetMetadata.Builder)DatasetMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TopicConfigOptions.Builder getConfigOptions() {
            return this.configOptions != null ? this.configOptions.toBuilder() : null;
        }

        public final void setConfigOptions(TopicConfigOptions.BuilderImpl configOptions) {
            this.configOptions = configOptions != null ? configOptions.build() : null;
        }

        @Override
        public final Builder configOptions(TopicConfigOptions configOptions) {
            this.configOptions = configOptions;
            return this;
        }

        public TopicDetails build() {
            return new TopicDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicDetails> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder userExperienceVersion(String var1);

        public Builder userExperienceVersion(TopicUserExperienceVersion var1);

        public Builder dataSets(Collection<DatasetMetadata> var1);

        public Builder dataSets(DatasetMetadata ... var1);

        public Builder dataSets(Consumer<DatasetMetadata.Builder> ... var1);

        public Builder configOptions(TopicConfigOptions var1);

        default public Builder configOptions(Consumer<TopicConfigOptions.Builder> configOptions) {
            return this.configOptions((TopicConfigOptions)((TopicConfigOptions.Builder)TopicConfigOptions.builder().applyMutation(configOptions)).build());
        }
    }
}

