/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.SheetImageScalingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SheetImageScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SheetImageScalingConfiguration> {
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingType").getter(SheetImageScalingConfiguration.getter(SheetImageScalingConfiguration::scalingTypeAsString)).setter(SheetImageScalingConfiguration.setter(Builder::scalingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SheetImageScalingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scalingType;

    private SheetImageScalingConfiguration(BuilderImpl builder) {
        this.scalingType = builder.scalingType;
    }

    public final SheetImageScalingType scalingType() {
        return SheetImageScalingType.fromValue(this.scalingType);
    }

    public final String scalingTypeAsString() {
        return this.scalingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SheetImageScalingConfiguration)) {
            return false;
        }
        SheetImageScalingConfiguration other = (SheetImageScalingConfiguration)obj;
        return Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SheetImageScalingConfiguration").add("ScalingType", (Object)this.scalingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ScalingType", SCALING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SheetImageScalingConfiguration, T> g) {
        return obj -> g.apply((SheetImageScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(SheetImageScalingConfiguration model) {
            this.scalingType(model.scalingType);
        }

        public final String getScalingType() {
            return this.scalingType;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(SheetImageScalingType scalingType) {
            this.scalingType(scalingType == null ? null : scalingType.toString());
            return this;
        }

        public SheetImageScalingConfiguration build() {
            return new SheetImageScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SheetImageScalingConfiguration> {
        public Builder scalingType(String var1);

        public Builder scalingType(SheetImageScalingType var1);
    }
}

