/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AxisBinding;
import software.amazon.awssdk.services.quicksight.model.LineChartSeriesSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataFieldSeriesItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataFieldSeriesItem> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(DataFieldSeriesItem.getter(DataFieldSeriesItem::fieldId)).setter(DataFieldSeriesItem.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> FIELD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldValue").getter(DataFieldSeriesItem.getter(DataFieldSeriesItem::fieldValue)).setter(DataFieldSeriesItem.setter(Builder::fieldValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldValue").build()}).build();
    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AxisBinding").getter(DataFieldSeriesItem.getter(DataFieldSeriesItem::axisBindingAsString)).setter(DataFieldSeriesItem.setter(Builder::axisBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()}).build();
    private static final SdkField<LineChartSeriesSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(DataFieldSeriesItem.getter(DataFieldSeriesItem::settings)).setter(DataFieldSeriesItem.setter(Builder::settings)).constructor(LineChartSeriesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, FIELD_VALUE_FIELD, AXIS_BINDING_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataFieldSeriesItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String fieldValue;
    private final String axisBinding;
    private final LineChartSeriesSettings settings;

    private DataFieldSeriesItem(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.fieldValue = builder.fieldValue;
        this.axisBinding = builder.axisBinding;
        this.settings = builder.settings;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String fieldValue() {
        return this.fieldValue;
    }

    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(this.axisBinding);
    }

    public final String axisBindingAsString() {
        return this.axisBinding;
    }

    public final LineChartSeriesSettings settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.axisBindingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataFieldSeriesItem)) {
            return false;
        }
        DataFieldSeriesItem other = (DataFieldSeriesItem)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.fieldValue(), other.fieldValue()) && Objects.equals(this.axisBindingAsString(), other.axisBindingAsString()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"DataFieldSeriesItem").add("FieldId", (Object)this.fieldId()).add("FieldValue", (Object)(this.fieldValue() == null ? null : "*** Sensitive Data Redacted ***")).add("AxisBinding", (Object)this.axisBindingAsString()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "FieldValue": {
                return Optional.ofNullable(clazz.cast(this.fieldValue()));
            }
            case "AxisBinding": {
                return Optional.ofNullable(clazz.cast(this.axisBindingAsString()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("FieldValue", FIELD_VALUE_FIELD);
        map.put("AxisBinding", AXIS_BINDING_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataFieldSeriesItem, T> g) {
        return obj -> g.apply((DataFieldSeriesItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String fieldValue;
        private String axisBinding;
        private LineChartSeriesSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DataFieldSeriesItem model) {
            this.fieldId(model.fieldId);
            this.fieldValue(model.fieldValue);
            this.axisBinding(model.axisBinding);
            this.settings(model.settings);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getFieldValue() {
            return this.fieldValue;
        }

        public final void setFieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
        }

        @Override
        public final Builder fieldValue(String fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public final String getAxisBinding() {
            return this.axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        public final LineChartSeriesSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(LineChartSeriesSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(LineChartSeriesSettings settings) {
            this.settings = settings;
            return this;
        }

        public DataFieldSeriesItem build() {
            return new DataFieldSeriesItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataFieldSeriesItem> {
        public Builder fieldId(String var1);

        public Builder fieldValue(String var1);

        public Builder axisBinding(String var1);

        public Builder axisBinding(AxisBinding var1);

        public Builder settings(LineChartSeriesSettings var1);

        default public Builder settings(Consumer<LineChartSeriesSettings.Builder> settings) {
            return this.settings((LineChartSeriesSettings)((LineChartSeriesSettings.Builder)LineChartSeriesSettings.builder().applyMutation(settings)).build());
        }
    }
}

