/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ArcThicknessOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArcConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArcConfiguration> {
    private static final SdkField<Double> ARC_ANGLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ArcAngle").getter(ArcConfiguration.getter(ArcConfiguration::arcAngle)).setter(ArcConfiguration.setter(Builder::arcAngle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcAngle").build()}).build();
    private static final SdkField<String> ARC_THICKNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArcThickness").getter(ArcConfiguration.getter(ArcConfiguration::arcThicknessAsString)).setter(ArcConfiguration.setter(Builder::arcThickness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArcThickness").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARC_ANGLE_FIELD, ARC_THICKNESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ArcConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double arcAngle;
    private final String arcThickness;

    private ArcConfiguration(BuilderImpl builder) {
        this.arcAngle = builder.arcAngle;
        this.arcThickness = builder.arcThickness;
    }

    public final Double arcAngle() {
        return this.arcAngle;
    }

    public final ArcThicknessOptions arcThickness() {
        return ArcThicknessOptions.fromValue(this.arcThickness);
    }

    public final String arcThicknessAsString() {
        return this.arcThickness;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arcAngle());
        hashCode = 31 * hashCode + Objects.hashCode(this.arcThicknessAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcConfiguration)) {
            return false;
        }
        ArcConfiguration other = (ArcConfiguration)obj;
        return Objects.equals(this.arcAngle(), other.arcAngle()) && Objects.equals(this.arcThicknessAsString(), other.arcThicknessAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ArcConfiguration").add("ArcAngle", (Object)this.arcAngle()).add("ArcThickness", (Object)this.arcThicknessAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArcAngle": {
                return Optional.ofNullable(clazz.cast(this.arcAngle()));
            }
            case "ArcThickness": {
                return Optional.ofNullable(clazz.cast(this.arcThicknessAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ArcAngle", ARC_ANGLE_FIELD);
        map.put("ArcThickness", ARC_THICKNESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArcConfiguration, T> g) {
        return obj -> g.apply((ArcConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double arcAngle;
        private String arcThickness;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcConfiguration model) {
            this.arcAngle(model.arcAngle);
            this.arcThickness(model.arcThickness);
        }

        public final Double getArcAngle() {
            return this.arcAngle;
        }

        public final void setArcAngle(Double arcAngle) {
            this.arcAngle = arcAngle;
        }

        @Override
        public final Builder arcAngle(Double arcAngle) {
            this.arcAngle = arcAngle;
            return this;
        }

        public final String getArcThickness() {
            return this.arcThickness;
        }

        public final void setArcThickness(String arcThickness) {
            this.arcThickness = arcThickness;
        }

        @Override
        public final Builder arcThickness(String arcThickness) {
            this.arcThickness = arcThickness;
            return this;
        }

        @Override
        public final Builder arcThickness(ArcThicknessOptions arcThickness) {
            this.arcThickness(arcThickness == null ? null : arcThickness.toString());
            return this;
        }

        public ArcConfiguration build() {
            return new ArcConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArcConfiguration> {
        public Builder arcAngle(Double var1);

        public Builder arcThickness(String var1);

        public Builder arcThickness(ArcThicknessOptions var1);
    }
}

