/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AssetBundleResourcePermissions;
import software.amazon.awssdk.services.quicksight.model.AssetBundleRestrictiveResourceIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetBundleImportJobFolderOverridePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetBundleImportJobFolderOverridePermissions> {
    private static final SdkField<List<String>> FOLDER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FolderIds").getter(AssetBundleImportJobFolderOverridePermissions.getter(AssetBundleImportJobFolderOverridePermissions::folderIds)).setter(AssetBundleImportJobFolderOverridePermissions.setter(Builder::folderIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssetBundleResourcePermissions> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Permissions").getter(AssetBundleImportJobFolderOverridePermissions.getter(AssetBundleImportJobFolderOverridePermissions::permissions)).setter(AssetBundleImportJobFolderOverridePermissions.setter(Builder::permissions)).constructor(AssetBundleResourcePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDER_IDS_FIELD, PERMISSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetBundleImportJobFolderOverridePermissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> folderIds;
    private final AssetBundleResourcePermissions permissions;

    private AssetBundleImportJobFolderOverridePermissions(BuilderImpl builder) {
        this.folderIds = builder.folderIds;
        this.permissions = builder.permissions;
    }

    public final boolean hasFolderIds() {
        return this.folderIds != null && !(this.folderIds instanceof SdkAutoConstructList);
    }

    public final List<String> folderIds() {
        return this.folderIds;
    }

    public final AssetBundleResourcePermissions permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFolderIds() ? this.folderIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetBundleImportJobFolderOverridePermissions)) {
            return false;
        }
        AssetBundleImportJobFolderOverridePermissions other = (AssetBundleImportJobFolderOverridePermissions)obj;
        return this.hasFolderIds() == other.hasFolderIds() && Objects.equals(this.folderIds(), other.folderIds()) && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"AssetBundleImportJobFolderOverridePermissions").add("FolderIds", this.hasFolderIds() ? this.folderIds() : null).add("Permissions", (Object)this.permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FolderIds": {
                return Optional.ofNullable(clazz.cast(this.folderIds()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FolderIds", FOLDER_IDS_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetBundleImportJobFolderOverridePermissions, T> g) {
        return obj -> g.apply((AssetBundleImportJobFolderOverridePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> folderIds = DefaultSdkAutoConstructList.getInstance();
        private AssetBundleResourcePermissions permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetBundleImportJobFolderOverridePermissions model) {
            this.folderIds(model.folderIds);
            this.permissions(model.permissions);
        }

        public final Collection<String> getFolderIds() {
            if (this.folderIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.folderIds;
        }

        public final void setFolderIds(Collection<String> folderIds) {
            this.folderIds = AssetBundleRestrictiveResourceIdListCopier.copy(folderIds);
        }

        @Override
        public final Builder folderIds(Collection<String> folderIds) {
            this.folderIds = AssetBundleRestrictiveResourceIdListCopier.copy(folderIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderIds(String ... folderIds) {
            this.folderIds(Arrays.asList(folderIds));
            return this;
        }

        public final AssetBundleResourcePermissions.Builder getPermissions() {
            return this.permissions != null ? this.permissions.toBuilder() : null;
        }

        public final void setPermissions(AssetBundleResourcePermissions.BuilderImpl permissions) {
            this.permissions = permissions != null ? permissions.build() : null;
        }

        @Override
        public final Builder permissions(AssetBundleResourcePermissions permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssetBundleImportJobFolderOverridePermissions build() {
            return new AssetBundleImportJobFolderOverridePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetBundleImportJobFolderOverridePermissions> {
        public Builder folderIds(Collection<String> var1);

        public Builder folderIds(String ... var1);

        public Builder permissions(AssetBundleResourcePermissions var1);

        default public Builder permissions(Consumer<AssetBundleResourcePermissions.Builder> permissions) {
            return this.permissions((AssetBundleResourcePermissions)((AssetBundleResourcePermissions.Builder)AssetBundleResourcePermissions.builder().applyMutation(permissions)).build());
        }
    }
}

