/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QSearchStatus;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateQuickSightQSearchConfigurationRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateQuickSightQSearchConfigurationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateQuickSightQSearchConfigurationRequest.getter(UpdateQuickSightQSearchConfigurationRequest::awsAccountId)).setter(UpdateQuickSightQSearchConfigurationRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> Q_SEARCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QSearchStatus").getter(UpdateQuickSightQSearchConfigurationRequest.getter(UpdateQuickSightQSearchConfigurationRequest::qSearchStatusAsString)).setter(UpdateQuickSightQSearchConfigurationRequest.setter(Builder::qSearchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QSearchStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, Q_SEARCH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateQuickSightQSearchConfigurationRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String qSearchStatus;

    private UpdateQuickSightQSearchConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.qSearchStatus = builder.qSearchStatus;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final QSearchStatus qSearchStatus() {
        return QSearchStatus.fromValue(this.qSearchStatus);
    }

    public final String qSearchStatusAsString() {
        return this.qSearchStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.qSearchStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickSightQSearchConfigurationRequest)) {
            return false;
        }
        UpdateQuickSightQSearchConfigurationRequest other = (UpdateQuickSightQSearchConfigurationRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.qSearchStatusAsString(), other.qSearchStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateQuickSightQSearchConfigurationRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("QSearchStatus", (Object)this.qSearchStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "QSearchStatus": {
                return Optional.ofNullable(clazz.cast(this.qSearchStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("QSearchStatus", Q_SEARCH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickSightQSearchConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateQuickSightQSearchConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String qSearchStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickSightQSearchConfigurationRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.qSearchStatus(model.qSearchStatus);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getQSearchStatus() {
            return this.qSearchStatus;
        }

        public final void setQSearchStatus(String qSearchStatus) {
            this.qSearchStatus = qSearchStatus;
        }

        @Override
        public final Builder qSearchStatus(String qSearchStatus) {
            this.qSearchStatus = qSearchStatus;
            return this;
        }

        @Override
        public final Builder qSearchStatus(QSearchStatus qSearchStatus) {
            this.qSearchStatus(qSearchStatus == null ? null : qSearchStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickSightQSearchConfigurationRequest build() {
            return new UpdateQuickSightQSearchConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateQuickSightQSearchConfigurationRequest> {
        public Builder awsAccountId(String var1);

        public Builder qSearchStatus(String var1);

        public Builder qSearchStatus(QSearchStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

